package io.intino.cesar.datahub;

import io.intino.alexandria.Timetag;
import io.intino.alexandria.Scale;
import io.intino.alexandria.event.Event;
import io.intino.alexandria.logger.Logger;

import java.util.concurrent.atomic.AtomicReference;

import java.time.Instant;

import java.util.function.Consumer;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.io.File;

public class ConsulTerminal {
	private final io.intino.alexandria.terminal.Connector connector;
	private final java.util.Map<java.util.function.BiConsumer<?, String>, List<java.util.function.Consumer<io.intino.alexandria.event.Event>>> consumers = new java.util.HashMap<>();

	public static String[] subscriptionChannels = new String[]{};

	public ConsulTerminal(io.intino.alexandria.terminal.Connector connector) {
		this.connector = connector;
	}

	public void publish(Object event, String split) {
		if (event instanceof io.intino.cesar.datahub.events.consul.process.ProcessLog) publish((io.intino.cesar.datahub.events.consul.process.ProcessLog) event);
		if (event instanceof io.intino.cesar.datahub.events.consul.process.ProcessStatus) publish((io.intino.cesar.datahub.events.consul.process.ProcessStatus) event);
		if (event instanceof io.intino.cesar.datahub.events.consul.server.ServerBoot) publish((io.intino.cesar.datahub.events.consul.server.ServerBoot) event);
		if (event instanceof io.intino.cesar.datahub.events.consul.server.ServerInfo) publish((io.intino.cesar.datahub.events.consul.server.ServerInfo) event);
		if (event instanceof io.intino.cesar.datahub.events.consul.server.ServerLog) publish((io.intino.cesar.datahub.events.consul.server.ServerLog) event);
		if (event instanceof io.intino.cesar.datahub.events.consul.server.ServerStatus) publish((io.intino.cesar.datahub.events.consul.server.ServerStatus) event);
	}


	public BatchSession batch(java.io.File temporalStageDirectory) {
		return new BatchSession(temporalStageDirectory);
	}

	public BatchSession batch(java.io.File temporalStageDirectory, Config config) {
		return new BatchSession(temporalStageDirectory, config);
	}


	public void publish(io.intino.alexandria.event.SessionEvent session) {
		connector.sendEvent(io.intino.alexandria.event.SessionEvent.PATH, session);
	}

	public void subscribe(SessionEventConsumer onEventReceived) {
		consumers.put(onEventReceived, List.of(event -> onEventReceived.accept(new io.intino.alexandria.event.SessionEvent(event.toMessage()), io.intino.alexandria.event.SessionEvent.PATH)));
		connector.attachListener(io.intino.alexandria.event.SessionEvent.PATH, consumers.get(onEventReceived).get(0));
	}

	public void publish(io.intino.cesar.datahub.events.consul.process.ProcessLog processLog) {
		connector.sendEvent("consul.process.ProcessLog", processLog);
	}

	public void publish(io.intino.cesar.datahub.events.consul.process.ProcessStatus processStatus) {
		connector.sendEvent("consul.process.ProcessStatus", processStatus);
	}

	public void publish(io.intino.cesar.datahub.events.consul.server.ServerBoot serverBoot) {
		connector.sendEvent("consul.server.ServerBoot", serverBoot);
	}

	public void publish(io.intino.cesar.datahub.events.consul.server.ServerInfo serverInfo) {
		connector.sendEvent("consul.server.ServerInfo", serverInfo);
	}

	public void publish(io.intino.cesar.datahub.events.consul.server.ServerLog serverLog) {
		connector.sendEvent("consul.server.ServerLog", serverLog);
	}

	public void publish(io.intino.cesar.datahub.events.consul.server.ServerStatus serverStatus) {
		connector.sendEvent("consul.server.ServerStatus", serverStatus);
	}



	private static final Object monitor = new Object();

	public synchronized void requestSeal() {
		synchronized(monitor) {
			connector.requestResponse("service.ness.seal", new Event(new io.intino.alexandria.message.Message("Seal")).ts(java.time.Instant.now()).toString(), s -> {
				synchronized(monitor) {monitor.notify();}
			});
			try {
				monitor.wait(1000 * 60 * 30);
			} catch (InterruptedException e) {
				io.intino.alexandria.logger.Logger.error(e);
			}
		}
	}

	public synchronized Instant requestLastSeal() {
		final AtomicReference<Instant> timestamp = new AtomicReference<>(Instant.now());
		synchronized(monitor) {
			connector.requestResponse("service.ness.seal.last", new Event(new io.intino.alexandria.message.Message("LastSeal")).ts(java.time.Instant.now()).toString(), s -> {
				synchronized(monitor) {
					if (s != null) timestamp.set(Instant.parse(s));
					monitor.notify();
				}
			});
			try {
				monitor.wait(1000 * 10);
			} catch (InterruptedException e) {
				io.intino.alexandria.logger.Logger.error(e);
			}
		}
		return timestamp.get();
	}

	public class BatchSession {
		private final java.io.File temporalStage;
		private final io.intino.alexandria.ingestion.SessionHandler sessionHandler;
		private final io.intino.alexandria.ingestion.EventSession eventSession;
		private final io.intino.alexandria.ingestion.SetSession setSession;
		private final Scale scale;

		public BatchSession(java.io.File temporalStage) {
			this(temporalStage, new Config());
		}

		public BatchSession(java.io.File temporalStage, Config config) {
			this.temporalStage = temporalStage;
			this.scale = config.scale;
			this.sessionHandler = new io.intino.alexandria.ingestion.SessionHandler(temporalStage);
			this.eventSession = sessionHandler.createEventSession(config.eventsBufferSize);
			this.setSession = sessionHandler.createSetSession(config.setsBufferSize);
		}

		public void feed(Event event, String split) {
            eventSession.put(tankOf(event, split), Timetag.of(event.ts(), this.scale), event);
		}

		public void feed(Event event, String split, Scale scale) {
			eventSession.put(tankOf(event, split), Timetag.of(event.ts(), scale), event);
		}

		public void feed(io.intino.alexandria.event.SessionEvent event) {
			eventSession.put(io.intino.alexandria.event.SessionEvent.PATH, Timetag.of(event.ts(), Scale.Day), event);
		}

		public void flush() {
			eventSession.flush();
			setSession.flush();
		}

		public void push(File dataHubStage) {
			eventSession.close();
			setSession.close();
			sessionHandler.pushTo(dataHubStage);
			//connector.sendEvent("service.ness.push", new Event(new io.intino.alexandria.message.Message("Push").set("stage", temporalStage.getName())));
		}

		public void push(String host, String user, String dataHubStageAbsolutePath) {
			eventSession.close();
			setSession.close();
			List<File> files = io.intino.alexandria.ingestion.FS.allFilesIn(temporalStage, path -> path.getName().endsWith(io.intino.alexandria.Session.SessionExtension)).collect(Collectors.toList());
			upload(files, host, user, dataHubStageAbsolutePath);
			temporalStage.renameTo(new File(temporalStage.getParentFile(), temporalStage.getName() + ".treated"));
		}

		public synchronized void seal() {
			synchronized(monitor) {
				connector.requestResponse("service.ness.seal", new Event(new io.intino.alexandria.message.Message("Seal").set("stage", temporalStage.getName())).ts(java.time.Instant.now()).toString(), s -> {
						synchronized(monitor) {
							monitor.notify();
						}
					}
				);
				try {
					monitor.wait();
				} catch (InterruptedException e) {
					io.intino.alexandria.logger.Logger.error(e);
				}
			}
        }

        private void upload(List<File> sessions, String host, String user, String dataHubStageAbsolutePath) {
			try {
				String connectionChain = user + "@" + host + ":" + dataHubStageAbsolutePath;
				Logger.info("Uploading sessions to " + connectionChain + "...");
				for (File s : sessions) {
					Process process = new ProcessBuilder("scp", s.getAbsolutePath(), connectionChain)
							.inheritIO()
							.start();
					process.waitFor(1, java.util.concurrent.TimeUnit.HOURS);
				}
				Logger.info("sessions uploaded");
			} catch (java.io.IOException | InterruptedException ignored) {
			}

		}

        private String tankOf(Event event, String split) {
        	if (event instanceof io.intino.cesar.datahub.events.consul.process.ProcessLog) return "consul.process.ProcessLog";
        	if (event instanceof io.intino.cesar.datahub.events.consul.process.ProcessStatus) return "consul.process.ProcessStatus";
        	if (event instanceof io.intino.cesar.datahub.events.consul.server.ServerBoot) return "consul.server.ServerBoot";
        	if (event instanceof io.intino.cesar.datahub.events.consul.server.ServerInfo) return "consul.server.ServerInfo";
        	if (event instanceof io.intino.cesar.datahub.events.consul.server.ServerLog) return "consul.server.ServerLog";
        	if (event instanceof io.intino.cesar.datahub.events.consul.server.ServerStatus) return "consul.server.ServerStatus";
        	return event.toMessage().type();
        }
	}

	public static class Config {
		private int eventsBufferSize = 1_000_000;
		private int setsBufferSize = 1_000_000;
		private Scale scale = Scale.Day;

		public Config scale(Scale scale) {
			this.scale = scale;
			return this;
		}

		public Config eventsBufferSize(int eventsBufferSize) {
			this.eventsBufferSize = eventsBufferSize;
			return this;
		}

		public Config setsBufferSize(int setsBufferSize) {
			this.setsBufferSize = setsBufferSize;
			return this;
		}
	}

	public interface SessionEventConsumer extends java.util.function.BiConsumer<io.intino.alexandria.event.SessionEvent, String> {
	}

	public interface ConsulserverServerStatusConsumer extends java.util.function.BiConsumer<io.intino.cesar.datahub.events.consul.server.ServerStatus, String> {
	}

	public interface ConsulserverServerLogConsumer extends java.util.function.BiConsumer<io.intino.cesar.datahub.events.consul.server.ServerLog, String> {
	}

	public interface ConsulprocessProcessStatusConsumer extends java.util.function.BiConsumer<io.intino.cesar.datahub.events.consul.process.ProcessStatus, String> {
	}

	public interface ConsulserverServerBootConsumer extends java.util.function.BiConsumer<io.intino.cesar.datahub.events.consul.server.ServerBoot, String> {
	}

	public interface ConsulprocessProcessLogConsumer extends java.util.function.BiConsumer<io.intino.cesar.datahub.events.consul.process.ProcessLog, String> {
	}

	public interface ConsulserverServerInfoConsumer extends java.util.function.BiConsumer<io.intino.cesar.datahub.events.consul.server.ServerInfo, String> {
	}
}