/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.hawtdispatch;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.fusesource.hawtdispatch.DispatchQueue;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.FieldVisitor;
import org.objectweb.asm.Label;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Opcodes;
import org.objectweb.asm.Type;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DispatchQueueProxy {
    public static <T> T create(Class<T> interfaceClass, T target, DispatchQueue queue) throws IllegalArgumentException {
        return DispatchQueueProxy.create(target.getClass().getClassLoader(), interfaceClass, target, queue);
    }

    public static synchronized <T> T create(ClassLoader classLoader, Class<T> interfaceClass, T target, DispatchQueue queue) throws IllegalArgumentException {
        Object rc;
        Class<T> proxyClass = DispatchQueueProxy.getProxyClass(classLoader, interfaceClass);
        Constructor<?> constructor = proxyClass.getConstructors()[0];
        try {
            rc = constructor.newInstance(target, queue);
        }
        catch (Throwable e) {
            throw new RuntimeException("Could not create an instance of the proxy due to: " + e.getMessage(), e);
        }
        return proxyClass.cast(rc);
    }

    private static <T> Class<T> getProxyClass(ClassLoader loader, Class<T> interfaceClass) throws IllegalArgumentException {
        String proxyName = DispatchQueueProxy.proxyName(interfaceClass);
        try {
            return loader.loadClass(proxyName);
        }
        catch (ClassNotFoundException e) {
            Generator generator = new Generator(loader, interfaceClass);
            return generator.generate();
        }
    }

    private static String proxyName(Class<?> clazz) {
        return clazz.getName() + "$__ACTOR_PROXY__";
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class Generator<T>
    implements Opcodes {
        private static final String RUNNABLE = "java/lang/Runnable";
        private static final String OBJECT_CLASS = "java/lang/Object";
        private static final String DISPATCH_QUEUE = DispatchQueue.class.getName().replace('.', '/');
        private final ClassLoader loader;
        private Method defineClassMethod;
        private final Class<T> interfaceClass;
        private String proxyName;
        private String interfaceName;

        private Generator(ClassLoader loader, Class<T> interfaceClass) throws RuntimeException {
            this.loader = loader;
            this.interfaceClass = interfaceClass;
            this.proxyName = DispatchQueueProxy.proxyName(interfaceClass).replace('.', '/');
            this.interfaceName = interfaceClass.getName().replace('.', '/');
            try {
                this.defineClassMethod = ClassLoader.class.getDeclaredMethod("defineClass", String.class, byte[].class, Integer.TYPE, Integer.TYPE);
                this.defineClassMethod.setAccessible(true);
            }
            catch (Throwable e) {
                throw new RuntimeException("Could not access the 'java.lang.ClassLoader.defineClass' method due to: " + e.getMessage(), e);
            }
        }

        private Class<T> generate() throws IllegalArgumentException {
            Method[] methods = this.interfaceClass.getMethods();
            for (int index = 0; index < methods.length; ++index) {
                String name = this.runnable(index, methods[index]).replace('/', '.');
                byte[] clazzBytes = this.dumpRunnable(index, methods[index]);
                this.defineClass(name, clazzBytes);
            }
            String name = this.proxyName.replace('/', '.');
            byte[] clazzBytes = this.dumpProxy(methods);
            return this.defineClass(name, clazzBytes);
        }

        private Class<T> defineClass(String name, byte[] classBytes) throws RuntimeException {
            try {
                return (Class)this.defineClassMethod.invoke((Object)this.loader, name, classBytes, 0, classBytes.length);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException("Could not define the generated class due to: " + e.getMessage(), e);
            }
            catch (InvocationTargetException e) {
                throw new RuntimeException("Could not define the generated class due to: " + e.getMessage(), e);
            }
        }

        public byte[] dumpProxy(Method[] methods) {
            ClassWriter cw = new ClassWriter(2);
            cw.visit(48, 33, this.proxyName, null, OBJECT_CLASS, new String[]{this.interfaceName});
            FieldVisitor fv = cw.visitField(18, "queue", this.sig(DISPATCH_QUEUE), null, null);
            fv.visitEnd();
            fv = cw.visitField(18, "target", this.sig(this.interfaceName), null, null);
            fv.visitEnd();
            MethodVisitor mv = cw.visitMethod(1, "<init>", "(" + this.sig(this.interfaceName) + this.sig(DISPATCH_QUEUE) + ")V", null, null);
            mv.visitCode();
            Label start = new Label();
            mv.visitLabel(start);
            mv.visitVarInsn(25, 0);
            mv.visitMethodInsn(183, OBJECT_CLASS, "<init>", "()V");
            mv.visitVarInsn(25, 0);
            mv.visitVarInsn(25, 2);
            mv.visitFieldInsn(181, this.proxyName, "queue", this.sig(DISPATCH_QUEUE));
            mv.visitVarInsn(25, 0);
            mv.visitVarInsn(25, 1);
            mv.visitFieldInsn(181, this.proxyName, "target", this.sig(this.interfaceName));
            mv.visitInsn(177);
            Label end = new Label();
            mv.visitLabel(end);
            mv.visitLocalVariable("this", this.sig(this.proxyName), null, start, end, 0);
            mv.visitLocalVariable("target", this.sig(this.interfaceName), null, start, end, 1);
            mv.visitLocalVariable("queue", this.sig(DISPATCH_QUEUE), null, start, end, 2);
            mv.visitMaxs(2, 3);
            mv.visitEnd();
            for (int index = 0; index < methods.length; ++index) {
                Method method = methods[index];
                Class<?>[] params = method.getParameterTypes();
                Type[] types = Type.getArgumentTypes(method);
                String methodSig = Type.getMethodDescriptor(method);
                mv = cw.visitMethod(1, method.getName(), methodSig, null, null);
                mv.visitCode();
                start = new Label();
                mv.visitLabel(start);
                mv.visitVarInsn(25, 0);
                mv.visitFieldInsn(180, this.proxyName, "queue", this.sig(DISPATCH_QUEUE));
                mv.visitTypeInsn(187, this.runnable(index, methods[index]));
                mv.visitInsn(89);
                mv.visitVarInsn(25, 0);
                mv.visitFieldInsn(180, this.proxyName, "target", this.sig(this.interfaceName));
                for (int i = 0; i < params.length; ++i) {
                    mv.visitVarInsn(types[i].getOpcode(21), 1 + i);
                }
                mv.visitMethodInsn(183, this.runnable(index, methods[index]), "<init>", "(" + this.sig(this.interfaceName) + this.sig(params) + ")V");
                mv.visitMethodInsn(185, DISPATCH_QUEUE, "execute", "(" + this.sig(RUNNABLE) + ")V");
                Type returnType = Type.getType(method.getReturnType());
                Integer returnValue = this.defaultConstant(returnType);
                if (returnValue != null) {
                    mv.visitInsn(returnValue);
                }
                mv.visitInsn(returnType.getOpcode(172));
                end = new Label();
                mv.visitLabel(end);
                mv.visitLocalVariable("this", this.sig(this.proxyName), null, start, end, 0);
                for (int i = 0; i < params.length; ++i) {
                    mv.visitLocalVariable("param" + i, this.sig(params[i]), null, start, end, 1 + i);
                }
                mv.visitMaxs(0, 0);
                mv.visitEnd();
            }
            cw.visitEnd();
            return cw.toByteArray();
        }

        private Integer defaultConstant(Type returnType) {
            Integer value = null;
            switch (returnType.getSort()) {
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: {
                    value = 3;
                    break;
                }
                case 7: {
                    value = 9;
                    break;
                }
                case 6: {
                    value = 11;
                    break;
                }
                case 8: {
                    value = 14;
                    break;
                }
                case 9: 
                case 10: {
                    value = 1;
                }
            }
            return value;
        }

        public byte[] dumpRunnable(int index, Method method) {
            int i;
            ClassWriter cw = new ClassWriter(2);
            String runnableClassName = this.runnable(index, method);
            cw.visit(48, 48, runnableClassName, null, OBJECT_CLASS, new String[]{RUNNABLE});
            FieldVisitor fv = cw.visitField(18, "target", this.sig(this.interfaceName), null, null);
            fv.visitEnd();
            Class<?>[] params = method.getParameterTypes();
            Type[] types = Type.getArgumentTypes(method);
            for (i = 0; i < params.length; ++i) {
                fv = cw.visitField(18, "param" + i, this.sig(params[i]), null, null);
                fv.visitEnd();
            }
            MethodVisitor mv = cw.visitMethod(1, "<init>", "(" + this.sig(this.interfaceName) + this.sig(params) + ")V", null, null);
            mv.visitCode();
            Label start = new Label();
            mv.visitLabel(start);
            mv.visitVarInsn(25, 0);
            mv.visitMethodInsn(183, OBJECT_CLASS, "<init>", "()V");
            mv.visitVarInsn(25, 0);
            mv.visitVarInsn(25, 1);
            mv.visitFieldInsn(181, runnableClassName, "target", this.sig(this.interfaceName));
            for (i = 0; i < params.length; ++i) {
                mv.visitVarInsn(25, 0);
                mv.visitVarInsn(types[i].getOpcode(21), 2 + i);
                mv.visitFieldInsn(181, runnableClassName, "param" + i, this.sig(params[i]));
            }
            mv.visitInsn(177);
            Label end = new Label();
            mv.visitLabel(end);
            mv.visitLocalVariable("this", this.sig(runnableClassName), null, start, end, 0);
            mv.visitLocalVariable("target", this.sig(this.interfaceName), null, start, end, 1);
            for (i = 0; i < params.length; ++i) {
                mv.visitLocalVariable("param" + i, this.sig(params[i]), null, start, end, 2 + i);
            }
            mv.visitMaxs(0, 0);
            mv.visitEnd();
            mv = cw.visitMethod(1, "run", "()V", null, null);
            mv.visitCode();
            start = new Label();
            mv.visitLabel(start);
            mv.visitVarInsn(25, 0);
            mv.visitFieldInsn(180, runnableClassName, "target", this.sig(this.interfaceName));
            for (i = 0; i < params.length; ++i) {
                mv.visitVarInsn(25, 0);
                mv.visitFieldInsn(180, runnableClassName, "param" + i, this.sig(params[i]));
            }
            String methodSig = Type.getMethodDescriptor(method);
            mv.visitMethodInsn(185, this.interfaceName, method.getName(), methodSig);
            Type returnType = Type.getType(method.getReturnType());
            if (returnType != Type.VOID_TYPE) {
                mv.visitInsn(87);
            }
            mv.visitInsn(177);
            end = new Label();
            mv.visitLabel(end);
            mv.visitLocalVariable("this", this.sig(runnableClassName), null, start, end, 0);
            mv.visitMaxs(0, 0);
            mv.visitEnd();
            cw.visitEnd();
            return cw.toByteArray();
        }

        private String sig(Class<?>[] params) {
            StringBuilder methodSig = new StringBuilder();
            for (int i = 0; i < params.length; ++i) {
                methodSig.append(this.sig(params[i]));
            }
            return methodSig.toString();
        }

        private String sig(Class<?> clazz) {
            return Type.getDescriptor(clazz);
        }

        private String runnable(int index, Method method) {
            return this.proxyName + "$" + index + "$" + method.getName();
        }

        private String sig(String name) {
            return "L" + name + ";";
        }
    }
}

