/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.store.kahadb.scheduler.legacy;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.activemq.store.kahadb.disk.index.BTreeIndex;
import org.apache.activemq.store.kahadb.disk.journal.Journal;
import org.apache.activemq.store.kahadb.disk.journal.Location;
import org.apache.activemq.store.kahadb.disk.page.Page;
import org.apache.activemq.store.kahadb.disk.page.PageFile;
import org.apache.activemq.store.kahadb.disk.page.Transaction;
import org.apache.activemq.store.kahadb.disk.util.IntegerMarshaller;
import org.apache.activemq.store.kahadb.disk.util.StringMarshaller;
import org.apache.activemq.store.kahadb.disk.util.VariableMarshaller;
import org.apache.activemq.store.kahadb.scheduler.legacy.LegacyJobLocation;
import org.apache.activemq.store.kahadb.scheduler.legacy.LegacyJobSchedulerImpl;
import org.apache.activemq.util.ByteSequence;
import org.apache.activemq.util.IOHelper;
import org.apache.activemq.util.LockFile;
import org.apache.activemq.util.ServiceStopper;
import org.apache.activemq.util.ServiceSupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class LegacyJobSchedulerStoreImpl
extends ServiceSupport {
    static final Logger LOG = LoggerFactory.getLogger(LegacyJobSchedulerStoreImpl.class);
    private static final int DATABASE_LOCKED_WAIT_DELAY = 10000;
    private File directory;
    private PageFile pageFile;
    private Journal journal;
    private LockFile lockFile;
    private final AtomicLong journalSize = new AtomicLong(0L);
    private boolean failIfDatabaseIsLocked;
    private int journalMaxFileLength = 0x2000000;
    private int journalMaxWriteBatchSize = 0x400000;
    private boolean enableIndexWriteAsync = false;
    private MetaData metaData = new MetaData(this);
    private final MetaDataMarshaller metaDataMarshaller = new MetaDataMarshaller(this);
    private final Map<String, LegacyJobSchedulerImpl> schedulers = new HashMap<String, LegacyJobSchedulerImpl>();

    LegacyJobSchedulerStoreImpl() {
    }

    public File getDirectory() {
        return this.directory;
    }

    public void setDirectory(File directory) {
        this.directory = directory;
    }

    public long size() {
        if (!this.isStarted()) {
            return 0L;
        }
        try {
            return this.journalSize.get() + this.pageFile.getDiskSize();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public LegacyJobSchedulerImpl getJobScheduler(String name) throws Exception {
        LegacyJobSchedulerImpl result = this.schedulers.get(name);
        if (result == null) {
            throw new NoSuchElementException("No such Job Scheduler in this store: " + name);
        }
        return result;
    }

    public Set<String> getJobSchedulerNames() throws Exception {
        Set<String> names = Collections.emptySet();
        if (!this.schedulers.isEmpty()) {
            return this.schedulers.keySet();
        }
        return names;
    }

    @Override
    protected void doStart() throws Exception {
        if (this.directory == null) {
            this.directory = new File(IOHelper.getDefaultDataDirectory() + File.pathSeparator + "delayedDB");
        }
        IOHelper.mkdirs(this.directory);
        this.lock();
        this.journal = new Journal();
        this.journal.setDirectory(this.directory);
        this.journal.setMaxFileLength(this.getJournalMaxFileLength());
        this.journal.setWriteBatchSize(this.getJournalMaxWriteBatchSize());
        this.journal.setSizeAccumulator(this.journalSize);
        this.journal.start();
        this.pageFile = new PageFile(this.directory, "scheduleDB");
        this.pageFile.setWriteBatchSize(1);
        this.pageFile.load();
        this.pageFile.tx().execute(new Transaction.Closure<IOException>(){

            @Override
            public void execute(Transaction tx) throws IOException {
                Page<Object> page;
                if (LegacyJobSchedulerStoreImpl.this.pageFile.getPageCount() == 0L) {
                    page = tx.allocate();
                    assert (page.getPageId() == 0L);
                    page.set(LegacyJobSchedulerStoreImpl.this.metaData);
                    ((LegacyJobSchedulerStoreImpl)LegacyJobSchedulerStoreImpl.this).metaData.page = page;
                    LegacyJobSchedulerStoreImpl.this.metaData.createIndexes(tx);
                    tx.store(((LegacyJobSchedulerStoreImpl)LegacyJobSchedulerStoreImpl.this).metaData.page, LegacyJobSchedulerStoreImpl.this.metaDataMarshaller, true);
                } else {
                    page = tx.load(0L, LegacyJobSchedulerStoreImpl.this.metaDataMarshaller);
                    LegacyJobSchedulerStoreImpl.this.metaData = (MetaData)page.get();
                    ((LegacyJobSchedulerStoreImpl)LegacyJobSchedulerStoreImpl.this).metaData.page = page;
                }
                LegacyJobSchedulerStoreImpl.this.metaData.load(tx);
                LegacyJobSchedulerStoreImpl.this.metaData.loadScheduler(tx, LegacyJobSchedulerStoreImpl.this.schedulers);
                for (LegacyJobSchedulerImpl js : LegacyJobSchedulerStoreImpl.this.schedulers.values()) {
                    try {
                        js.start();
                    }
                    catch (Exception e) {
                        LOG.error("Failed to load " + js.getName(), e);
                    }
                }
            }
        });
        this.pageFile.flush();
        LOG.info(this + " started");
    }

    @Override
    protected void doStop(ServiceStopper stopper) throws Exception {
        for (LegacyJobSchedulerImpl js : this.schedulers.values()) {
            js.stop();
        }
        if (this.pageFile != null) {
            this.pageFile.unload();
        }
        if (this.journal != null) {
            this.journal.close();
        }
        if (this.lockFile != null) {
            this.lockFile.unlock();
        }
        this.lockFile = null;
        LOG.info(this + " stopped");
    }

    ByteSequence getPayload(Location location) throws IllegalStateException, IOException {
        ByteSequence result = null;
        result = this.journal.read(location);
        return result;
    }

    Location write(ByteSequence payload, boolean sync) throws IllegalStateException, IOException {
        return this.journal.write(payload, sync);
    }

    private void lock() throws IOException {
        if (this.lockFile == null) {
            File lockFileName = new File(this.directory, "lock");
            this.lockFile = new LockFile(lockFileName, true);
            if (this.failIfDatabaseIsLocked) {
                this.lockFile.lock();
            } else {
                while (true) {
                    try {
                        this.lockFile.lock();
                    }
                    catch (IOException e) {
                        LOG.info("Database " + lockFileName + " is locked... waiting " + 10 + " seconds for the database to be unlocked. Reason: " + e);
                        try {
                            Thread.sleep(10000L);
                        }
                        catch (InterruptedException interruptedException) {}
                        continue;
                    }
                    break;
                }
            }
        }
    }

    PageFile getPageFile() {
        this.pageFile.isLoaded();
        return this.pageFile;
    }

    public boolean isFailIfDatabaseIsLocked() {
        return this.failIfDatabaseIsLocked;
    }

    public void setFailIfDatabaseIsLocked(boolean failIfDatabaseIsLocked) {
        this.failIfDatabaseIsLocked = failIfDatabaseIsLocked;
    }

    public int getJournalMaxFileLength() {
        return this.journalMaxFileLength;
    }

    public void setJournalMaxFileLength(int journalMaxFileLength) {
        this.journalMaxFileLength = journalMaxFileLength;
    }

    public int getJournalMaxWriteBatchSize() {
        return this.journalMaxWriteBatchSize;
    }

    public void setJournalMaxWriteBatchSize(int journalMaxWriteBatchSize) {
        this.journalMaxWriteBatchSize = journalMaxWriteBatchSize;
    }

    public boolean isEnableIndexWriteAsync() {
        return this.enableIndexWriteAsync;
    }

    public void setEnableIndexWriteAsync(boolean enableIndexWriteAsync) {
        this.enableIndexWriteAsync = enableIndexWriteAsync;
    }

    public String toString() {
        return "LegacyJobSchedulerStore:" + this.directory;
    }

    class JobSchedulerMarshaller
    extends VariableMarshaller<LegacyJobSchedulerImpl> {
        private final LegacyJobSchedulerStoreImpl store;

        JobSchedulerMarshaller(LegacyJobSchedulerStoreImpl store) {
            this.store = store;
        }

        @Override
        public LegacyJobSchedulerImpl readPayload(DataInput dataIn) throws IOException {
            LegacyJobSchedulerImpl result = new LegacyJobSchedulerImpl(this.store);
            result.read(dataIn);
            return result;
        }

        @Override
        public void writePayload(LegacyJobSchedulerImpl js, DataOutput dataOut) throws IOException {
            js.write(dataOut);
        }
    }

    class ValueMarshaller
    extends VariableMarshaller<List<LegacyJobLocation>> {
        ValueMarshaller() {
        }

        @Override
        public List<LegacyJobLocation> readPayload(DataInput dataIn) throws IOException {
            ArrayList<LegacyJobLocation> result = new ArrayList<LegacyJobLocation>();
            int size = dataIn.readInt();
            for (int i = 0; i < size; ++i) {
                LegacyJobLocation jobLocation = new LegacyJobLocation();
                jobLocation.readExternal(dataIn);
                result.add(jobLocation);
            }
            return result;
        }

        @Override
        public void writePayload(List<LegacyJobLocation> value, DataOutput dataOut) throws IOException {
            dataOut.writeInt(value.size());
            for (LegacyJobLocation jobLocation : value) {
                jobLocation.writeExternal(dataOut);
            }
        }
    }

    class MetaDataMarshaller
    extends VariableMarshaller<MetaData> {
        private final LegacyJobSchedulerStoreImpl store;

        MetaDataMarshaller(LegacyJobSchedulerStoreImpl store) {
            this.store = store;
        }

        @Override
        public MetaData readPayload(DataInput dataIn) throws IOException {
            MetaData rc = new MetaData(this.store);
            rc.read(dataIn);
            return rc;
        }

        @Override
        public void writePayload(MetaData object, DataOutput dataOut) throws IOException {
            object.write(dataOut);
        }
    }

    protected class MetaData {
        private final LegacyJobSchedulerStoreImpl store;
        Page<MetaData> page;
        BTreeIndex<Integer, Integer> journalRC;
        BTreeIndex<String, LegacyJobSchedulerImpl> storedSchedulers;

        protected MetaData(LegacyJobSchedulerStoreImpl store) {
            this.store = store;
        }

        void createIndexes(Transaction tx) throws IOException {
            this.storedSchedulers = new BTreeIndex(LegacyJobSchedulerStoreImpl.this.pageFile, tx.allocate().getPageId());
            this.journalRC = new BTreeIndex(LegacyJobSchedulerStoreImpl.this.pageFile, tx.allocate().getPageId());
        }

        void load(Transaction tx) throws IOException {
            this.storedSchedulers.setKeyMarshaller(StringMarshaller.INSTANCE);
            this.storedSchedulers.setValueMarshaller(new JobSchedulerMarshaller(this.store));
            this.storedSchedulers.load(tx);
            this.journalRC.setKeyMarshaller(IntegerMarshaller.INSTANCE);
            this.journalRC.setValueMarshaller(IntegerMarshaller.INSTANCE);
            this.journalRC.load(tx);
        }

        void loadScheduler(Transaction tx, Map<String, LegacyJobSchedulerImpl> schedulers) throws IOException {
            Iterator<Map.Entry<String, LegacyJobSchedulerImpl>> i = this.storedSchedulers.iterator(tx);
            while (i.hasNext()) {
                Map.Entry<String, LegacyJobSchedulerImpl> entry = i.next();
                entry.getValue().load(tx);
                schedulers.put(entry.getKey(), entry.getValue());
            }
        }

        public void read(DataInput is) throws IOException {
            this.storedSchedulers = new BTreeIndex(LegacyJobSchedulerStoreImpl.this.pageFile, is.readLong());
            this.storedSchedulers.setKeyMarshaller(StringMarshaller.INSTANCE);
            this.storedSchedulers.setValueMarshaller(new JobSchedulerMarshaller(this.store));
            this.journalRC = new BTreeIndex(LegacyJobSchedulerStoreImpl.this.pageFile, is.readLong());
            this.journalRC.setKeyMarshaller(IntegerMarshaller.INSTANCE);
            this.journalRC.setValueMarshaller(IntegerMarshaller.INSTANCE);
        }

        public void write(DataOutput os) throws IOException {
            os.writeLong(this.storedSchedulers.getPageId());
            os.writeLong(this.journalRC.getPageId());
        }
    }
}

