/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.store.kahadb.plist;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.activemq.management.SizeStatisticImpl;
import org.apache.activemq.store.PList;
import org.apache.activemq.store.PListEntry;
import org.apache.activemq.store.kahadb.disk.index.ListIndex;
import org.apache.activemq.store.kahadb.disk.index.ListNode;
import org.apache.activemq.store.kahadb.disk.journal.Location;
import org.apache.activemq.store.kahadb.disk.page.Transaction;
import org.apache.activemq.store.kahadb.disk.util.LocationMarshaller;
import org.apache.activemq.store.kahadb.disk.util.StringMarshaller;
import org.apache.activemq.store.kahadb.plist.PListStoreImpl;
import org.apache.activemq.util.ByteSequence;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PListImpl
extends ListIndex<String, Location>
implements PList {
    static final Logger LOG = LoggerFactory.getLogger(PListImpl.class);
    final PListStoreImpl store;
    private String name;
    Object indexLock;
    private final SizeStatisticImpl messageSize;

    PListImpl(PListStoreImpl store) {
        this.store = store;
        this.indexLock = store.getIndexLock();
        this.setPageFile(store.getPageFile());
        this.setKeyMarshaller(StringMarshaller.INSTANCE);
        this.setValueMarshaller(LocationMarshaller.INSTANCE);
        this.messageSize = new SizeStatisticImpl("messageSize", "The size in bytes of the pending messages");
        this.messageSize.setEnabled(true);
    }

    public void setName(String name) {
        this.name = name;
    }

    @Override
    public String getName() {
        return this.name;
    }

    void read(DataInput in) throws IOException {
        this.setHeadPageId(in.readLong());
    }

    public void write(DataOutput out) throws IOException {
        out.writeLong(this.getHeadPageId());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void destroy() throws IOException {
        Object object = this.indexLock;
        synchronized (object) {
            this.store.getPageFile().tx().execute(new Transaction.Closure<IOException>(){

                @Override
                public void execute(Transaction tx) throws IOException {
                    PListImpl.this.clear(tx);
                    PListImpl.this.unload(tx);
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object addLast(final String id, ByteSequence bs) throws IOException {
        final Location location = this.store.write(bs, false);
        Object object = this.indexLock;
        synchronized (object) {
            this.store.getPageFile().tx().execute(new Transaction.Closure<IOException>(){

                @Override
                public void execute(Transaction tx) throws IOException {
                    PListImpl.this.add(tx, id, location);
                }
            });
        }
        return new Locator(id);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object addFirst(final String id, ByteSequence bs) throws IOException {
        final Location location = this.store.write(bs, false);
        Object object = this.indexLock;
        synchronized (object) {
            this.store.getPageFile().tx().execute(new Transaction.Closure<IOException>(){

                @Override
                public void execute(Transaction tx) throws IOException {
                    PListImpl.this.addFirst(tx, id, location);
                }
            });
        }
        return new Locator(id);
    }

    @Override
    public boolean remove(Object l) throws IOException {
        Locator locator = (Locator)l;
        assert (locator != null);
        assert (locator.plist() == this);
        return this.remove(locator.id);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean remove(final String id) throws IOException {
        final AtomicBoolean result = new AtomicBoolean();
        Object object = this.indexLock;
        synchronized (object) {
            this.store.getPageFile().tx().execute(new Transaction.Closure<IOException>(){

                @Override
                public void execute(Transaction tx) throws IOException {
                    result.set(PListImpl.this.remove(tx, id) != null);
                }
            });
        }
        return result.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean remove(final long position) throws IOException {
        final AtomicBoolean result = new AtomicBoolean();
        Object object = this.indexLock;
        synchronized (object) {
            this.store.getPageFile().tx().execute(new Transaction.Closure<IOException>(){

                @Override
                public void execute(Transaction tx) throws IOException {
                    Iterator iterator = PListImpl.this.iterator(tx, position);
                    if (iterator.hasNext()) {
                        iterator.next();
                        iterator.remove();
                        result.set(true);
                    } else {
                        result.set(false);
                    }
                }
            });
        }
        return result.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PListEntry get(final long position) throws IOException {
        PListEntry result = null;
        final AtomicReference ref = new AtomicReference();
        Object object = this.indexLock;
        synchronized (object) {
            this.store.getPageFile().tx().execute(new Transaction.Closure<IOException>(){

                @Override
                public void execute(Transaction tx) throws IOException {
                    Iterator iterator = PListImpl.this.iterator(tx, position);
                    ref.set(iterator.next());
                }
            });
        }
        if (ref.get() != null) {
            ByteSequence bs = this.store.getPayload((Location)((Map.Entry)ref.get()).getValue());
            result = new PListEntry((String)((Map.Entry)ref.get()).getKey(), bs, new Locator((String)((Map.Entry)ref.get()).getKey()));
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PListEntry getFirst() throws IOException {
        PListEntry result = null;
        final AtomicReference ref = new AtomicReference();
        Object object = this.indexLock;
        synchronized (object) {
            this.store.getPageFile().tx().execute(new Transaction.Closure<IOException>(){

                @Override
                public void execute(Transaction tx) throws IOException {
                    ref.set(PListImpl.this.getFirst(tx));
                }
            });
        }
        if (ref.get() != null) {
            ByteSequence bs = this.store.getPayload((Location)((Map.Entry)ref.get()).getValue());
            result = new PListEntry((String)((Map.Entry)ref.get()).getKey(), bs, new Locator((String)((Map.Entry)ref.get()).getKey()));
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PListEntry getLast() throws IOException {
        PListEntry result = null;
        final AtomicReference ref = new AtomicReference();
        Object object = this.indexLock;
        synchronized (object) {
            this.store.getPageFile().tx().execute(new Transaction.Closure<IOException>(){

                @Override
                public void execute(Transaction tx) throws IOException {
                    ref.set(PListImpl.this.getLast(tx));
                }
            });
        }
        if (ref.get() != null) {
            ByteSequence bs = this.store.getPayload((Location)((Map.Entry)ref.get()).getValue());
            result = new PListEntry((String)((Map.Entry)ref.get()).getKey(), bs, new Locator((String)((Map.Entry)ref.get()).getKey()));
        }
        return result;
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0L;
    }

    @Override
    public PList.PListIterator iterator() throws IOException {
        return new PListIteratorImpl();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void claimFileLocations(final Set<Integer> candidates) throws IOException {
        Object object = this.indexLock;
        synchronized (object) {
            if (this.loaded.get()) {
                this.store.getPageFile().tx().execute(new Transaction.Closure<IOException>(){

                    @Override
                    public void execute(Transaction tx) throws IOException {
                        Iterator iterator = PListImpl.this.iterator(tx);
                        while (iterator.hasNext()) {
                            Location location = (Location)iterator.next().getValue();
                            candidates.remove(location.getDataFileId());
                        }
                    }
                });
            }
        }
    }

    @Override
    public long messageSize() {
        return this.messageSize.getTotalSize();
    }

    @Override
    public synchronized Location add(Transaction tx, String key, Location value) throws IOException {
        Location location = super.add(tx, key, value);
        this.messageSize.addSize(value.getSize());
        return location;
    }

    @Override
    public synchronized Location addFirst(Transaction tx, String key, Location value) throws IOException {
        Location location = super.addFirst(tx, key, value);
        this.messageSize.addSize(value.getSize());
        return location;
    }

    @Override
    public synchronized void clear(Transaction tx) throws IOException {
        this.messageSize.reset();
        super.clear(tx);
    }

    @Override
    protected synchronized void onLoad(ListNode<String, Location> node, Transaction tx) {
        try {
            Iterator<Map.Entry<String, Location>> i = node.iterator(tx);
            while (i.hasNext()) {
                this.messageSize.addSize(i.next().getValue().getSize());
            }
        }
        catch (IOException e) {
            LOG.warn("could not increment message size", e);
        }
    }

    @Override
    public void onRemove(Map.Entry<String, Location> removed) {
        super.onRemove(removed);
        if (removed != null) {
            this.messageSize.addSize(-removed.getValue().getSize());
        }
    }

    public String toString() {
        return this.name + "[headPageId=" + this.getHeadPageId() + ",tailPageId=" + this.getTailPageId() + ", size=" + this.size() + "]";
    }

    final class PListIteratorImpl
    implements PList.PListIterator {
        final Iterator<Map.Entry<String, Location>> iterator;
        final Transaction tx;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        PListIteratorImpl() throws IOException {
            this.tx = PListImpl.this.store.pageFile.tx();
            Object object = PListImpl.this.indexLock;
            synchronized (object) {
                this.iterator = PListImpl.this.iterator(this.tx);
            }
        }

        @Override
        public boolean hasNext() {
            return this.iterator.hasNext();
        }

        @Override
        public PListEntry next() {
            Map.Entry<String, Location> entry = this.iterator.next();
            ByteSequence bs = null;
            try {
                bs = PListImpl.this.store.getPayload(entry.getValue());
            }
            catch (IOException unexpected) {
                NoSuchElementException e = new NoSuchElementException(unexpected.getLocalizedMessage());
                e.initCause(unexpected);
                throw e;
            }
            return new PListEntry(entry.getKey(), bs, new Locator(entry.getKey()));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void remove() {
            try {
                Object object = PListImpl.this.indexLock;
                synchronized (object) {
                    this.tx.execute(new Transaction.Closure<IOException>(){

                        @Override
                        public void execute(Transaction tx) throws IOException {
                            PListIteratorImpl.this.iterator.remove();
                        }
                    });
                }
            }
            catch (IOException unexpected) {
                IllegalStateException e = new IllegalStateException(unexpected);
                e.initCause(unexpected);
                throw e;
            }
        }

        @Override
        public void release() {
            try {
                this.tx.rollback();
            }
            catch (IOException unexpected) {
                IllegalStateException e = new IllegalStateException(unexpected);
                e.initCause(unexpected);
                throw e;
            }
        }
    }

    class Locator {
        final String id;

        Locator(String id) {
            this.id = id;
        }

        PListImpl plist() {
            return PListImpl.this;
        }
    }
}

