/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.plugin;

import java.io.IOException;
import java.net.MalformedURLException;
import java.util.LinkedList;
import java.util.Map;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.activemq.broker.BrokerContext;
import org.apache.activemq.spring.Utils;
import org.apache.activemq.util.XBeanByteConverterUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.core.io.Resource;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class PropertiesPlaceHolderUtil {
    public static final Logger LOG = LoggerFactory.getLogger(PropertiesPlaceHolderUtil.class);
    static final Pattern pattern = Pattern.compile("\\$\\{([^\\}]+)\\}");
    final Properties properties;

    public PropertiesPlaceHolderUtil(Properties properties) {
        this.properties = properties;
    }

    public void filter(Properties toFilter) {
        for (Map.Entry<Object, Object> entry : toFilter.entrySet()) {
            String newVal;
            String val = (String)entry.getValue();
            if (val.equals(newVal = this.filter(val))) continue;
            toFilter.put(entry.getKey(), newVal);
        }
    }

    public String filter(String str) {
        Matcher matcher;
        int start = 0;
        while ((matcher = pattern.matcher(str)).find(start)) {
            String group = matcher.group(1);
            String property = this.properties.getProperty(group);
            if (property != null) {
                str = matcher.replaceFirst(Matcher.quoteReplacement(property));
                continue;
            }
            start = matcher.end();
        }
        return this.replaceBytePostfix(str);
    }

    private String replaceBytePostfix(String str) {
        try {
            Long value = XBeanByteConverterUtil.convertToLongBytes(str);
            return String.valueOf(value);
        }
        catch (IllegalArgumentException ignored) {
            LOG.debug("iae on: " + str, ignored);
            return str;
        }
    }

    public void mergeProperties(Document doc, Properties initialProperties, BrokerContext brokerContext) {
        LinkedList<String> resources = new LinkedList<String>();
        LinkedList<String> propertiesClazzes = new LinkedList<String>();
        NodeList beans = doc.getElementsByTagNameNS("*", "bean");
        for (int i = 0; i < beans.getLength(); ++i) {
            Node bean = beans.item(0);
            if (!bean.hasAttributes() || !bean.getAttributes().getNamedItem("class").getTextContent().contains("PropertyPlaceholderConfigurer") || !bean.hasChildNodes()) continue;
            NodeList beanProps = bean.getChildNodes();
            for (int j = 0; j < beanProps.getLength(); ++j) {
                Node value;
                int k;
                NodeList values;
                Element beanPropElement;
                Node beanProp = beanProps.item(j);
                if (1 != beanProp.getNodeType() || !beanProp.hasAttributes() || beanProp.getAttributes().getNamedItem("name") == null) continue;
                String propertyName = beanProp.getAttributes().getNamedItem("name").getTextContent();
                if ("locations".equals(propertyName)) {
                    beanPropElement = (Element)beanProp;
                    values = beanPropElement.getElementsByTagNameNS("*", "value");
                    for (k = 0; k < values.getLength(); ++k) {
                        value = values.item(k);
                        resources.add(value.getFirstChild().getTextContent());
                    }
                    continue;
                }
                if (!"properties".equals(propertyName)) continue;
                beanPropElement = (Element)beanProp;
                values = beanPropElement.getElementsByTagNameNS("*", "bean");
                for (k = 0; k < values.getLength(); ++k) {
                    Node beanClassTypeNode;
                    value = values.item(k);
                    if (!value.hasAttributes() || (beanClassTypeNode = value.getAttributes().getNamedItem("class")) == null) continue;
                    propertiesClazzes.add(beanClassTypeNode.getFirstChild().getTextContent());
                }
            }
        }
        for (String value : propertiesClazzes) {
            try {
                Object springBean = this.getClass().getClassLoader().loadClass(value).newInstance();
                if (!(springBean instanceof FactoryBean)) continue;
                initialProperties.putAll((Map<?, ?>)((Properties)FactoryBean.class.getMethod("getObject", null).invoke(springBean, new Object[0])));
            }
            catch (Throwable e) {
                LOG.debug("unexpected exception processing properties bean class: " + propertiesClazzes, e);
            }
        }
        LinkedList<Resource> propResources = new LinkedList<Resource>();
        for (String value : resources) {
            try {
                if (value.isEmpty()) continue;
                propResources.add(Utils.resourceFromString(this.filter(value)));
            }
            catch (MalformedURLException e) {
                LOG.info("failed to resolve resource: " + value, e);
            }
        }
        for (Resource resource : propResources) {
            Properties properties = new Properties();
            try {
                properties.load(resource.getInputStream());
            }
            catch (IOException e) {
                LOG.info("failed to load properties resource: " + resource, e);
            }
            initialProperties.putAll((Map<?, ?>)properties);
        }
    }
}

