/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.plugin;

import java.util.LinkedList;
import java.util.List;
import org.apache.activemq.filter.DestinationMapEntry;
import org.apache.activemq.plugin.DefaultConfigurationProcessor;
import org.apache.activemq.plugin.RuntimeConfigurationBroker;
import org.apache.activemq.schema.core.DtoAuthorizationEntry;
import org.apache.activemq.schema.core.DtoAuthorizationMap;
import org.apache.activemq.schema.core.DtoAuthorizationPlugin;
import org.apache.activemq.security.AuthorizationBroker;
import org.apache.activemq.security.AuthorizationMap;
import org.apache.activemq.security.TempDestinationAuthorizationEntry;
import org.apache.activemq.security.XBeanAuthorizationEntry;
import org.apache.activemq.security.XBeanAuthorizationMap;

public class AuthorizationPluginProcessor
extends DefaultConfigurationProcessor {
    public AuthorizationPluginProcessor(RuntimeConfigurationBroker plugin, Class configurationClass) {
        super(plugin, configurationClass);
    }

    @Override
    public void modify(Object existing, Object candidate) {
        try {
            AuthorizationBroker authorizationBroker = (AuthorizationBroker)this.plugin.getBrokerService().getBroker().getAdaptor(AuthorizationBroker.class);
            authorizationBroker.setAuthorizationMap(this.fromDto(this.filter(candidate, DtoAuthorizationPlugin.Map.class)));
        }
        catch (Exception e) {
            this.plugin.info("failed to apply modified AuthorizationMap to AuthorizationBroker", e);
        }
    }

    private AuthorizationMap fromDto(List<Object> map) {
        XBeanAuthorizationMap xBeanAuthorizationMap = new XBeanAuthorizationMap();
        for (Object o : map) {
            if (o instanceof DtoAuthorizationPlugin.Map) {
                DtoAuthorizationPlugin.Map dtoMap = (DtoAuthorizationPlugin.Map)o;
                LinkedList<DestinationMapEntry> entries = new LinkedList<DestinationMapEntry>();
                for (Object authMap : this.filter(dtoMap.getAuthorizationMap(), DtoAuthorizationMap.AuthorizationEntries.class)) {
                    for (Object entry : this.filter(this.getContents(authMap), DtoAuthorizationEntry.class)) {
                        entries.add(this.fromDto(entry, new XBeanAuthorizationEntry()));
                    }
                }
                xBeanAuthorizationMap.setAuthorizationEntries(entries);
                xBeanAuthorizationMap.setGroupClass(dtoMap.getAuthorizationMap().getGroupClass());
                try {
                    xBeanAuthorizationMap.afterPropertiesSet();
                }
                catch (Exception e) {
                    this.plugin.info("failed to update xBeanAuthorizationMap auth entries:", e);
                }
                for (Object entry : this.filter(dtoMap.getAuthorizationMap(), DtoAuthorizationMap.TempDestinationAuthorizationEntry.class)) {
                    DtoAuthorizationMap.TempDestinationAuthorizationEntry dtoEntry = (DtoAuthorizationMap.TempDestinationAuthorizationEntry)entry;
                    xBeanAuthorizationMap.setTempDestinationAuthorizationEntry(this.fromDto(dtoEntry.getTempDestinationAuthorizationEntry(), new TempDestinationAuthorizationEntry()));
                }
                continue;
            }
            this.plugin.info("No support for updates to: " + o);
        }
        return xBeanAuthorizationMap;
    }
}

