/*
 * Decompiled with CFR 0.152.
 */
package io.intino.magritte.lang.semantics.constraints.parameter;

import io.intino.magritte.lang.model.Element;
import io.intino.magritte.lang.model.EmptyNode;
import io.intino.magritte.lang.model.Node;
import io.intino.magritte.lang.model.Parameter;
import io.intino.magritte.lang.model.Parametrized;
import io.intino.magritte.lang.model.Primitive;
import io.intino.magritte.lang.model.Tag;
import io.intino.magritte.lang.model.rules.Size;
import io.intino.magritte.lang.model.rules.variable.ReferenceRule;
import io.intino.magritte.lang.model.rules.variable.VariableRule;
import io.intino.magritte.lang.semantics.constraints.parameter.ParameterConstraint;
import io.intino.magritte.lang.semantics.errorcollector.SemanticException;
import io.intino.magritte.lang.semantics.errorcollector.SemanticNotification;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public final class ReferenceParameter
extends ParameterConstraint {
    private final String name;
    private final String type;
    private final String facet;
    private final Size size;
    private final int position;
    private final List<Tag> flags;
    private final String scope;
    private VariableRule rule;

    public ReferenceParameter(String name, String type, String facet, Size size, int position, String scope, VariableRule rule, List<Tag> flags) {
        this.name = name;
        this.type = type;
        this.facet = facet;
        this.size = size;
        this.position = position;
        this.scope = scope;
        this.rule = rule;
        this.flags = flags;
    }

    @Override
    public void check(Element element) throws SemanticException {
        if (element instanceof Node && (((Node)element).isReference() || ((Node)element).isAbstract())) {
            return;
        }
        Parametrized parametrized = (Parametrized)((Object)element);
        Parameter parameter = ReferenceParameter.findParameter(parametrized.parameters(), this.facet, this.name, this.position);
        if (parameter == null) {
            if (this.size.isRequired() && (!(element instanceof Node) || this.isNotAbstractNode(element))) {
                this.error = ParameterConstraint.ParameterError.NOT_FOUND;
                this.error(element, null, this.error);
            }
            return;
        }
        if (this.checkAsReference(parameter.values())) {
            parameter.name(this.name());
            parameter.type(this.type());
            parameter.aspect(this.facet);
            parameter.flags(this.flags);
            parameter.rule(this.rule);
            parameter.scope(this.scope);
        } else {
            this.error(element, parameter, this.error);
        }
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public Primitive type() {
        return Primitive.REFERENCE;
    }

    @Override
    public String aspect() {
        return this.facet;
    }

    public String referenceType() {
        return this.type;
    }

    @Override
    public Size size() {
        return this.size;
    }

    @Override
    public int position() {
        return this.position;
    }

    @Override
    public String scope() {
        return this.scope;
    }

    @Override
    public VariableRule rule() {
        return this.rule;
    }

    @Override
    public List<Tag> flags() {
        return Collections.unmodifiableList(this.flags);
    }

    public boolean isConstraintOf(Parameter parameter) {
        Parameter expected = ReferenceParameter.findParameter(parameter.container().parameters(), this.facet, this.name, this.position);
        return parameter.equals(expected);
    }

    private boolean checkAsReference(List<Object> values) {
        boolean size = this.size().accept(values);
        if (!size) {
            this.error = ParameterConstraint.ParameterError.SIZE;
        }
        return size && this.checkReferences(values);
    }

    private boolean checkReferences(List<Object> values) {
        if (values.isEmpty()) {
            return false;
        }
        if (values.get(0) instanceof EmptyNode) {
            return values.size() == 1;
        }
        for (Object value : values) {
            if (value instanceof Primitive.Reference && !this.areCompatibleReference(((Primitive.Reference)value).reference()) && !this.isCompatibleInstanceReference((Primitive.Reference)value)) {
                this.error = ParameterConstraint.ParameterError.RULE;
                return false;
            }
            if (value instanceof Node || value instanceof Primitive.Reference) continue;
            return false;
        }
        return true;
    }

    private boolean isCompatibleInstanceReference(Primitive.Reference value) {
        return !(this.rule() instanceof ReferenceRule) || value.isToInstance() && this.intersect(new ArrayList<String>(value.instanceTypes()), new ArrayList<String>(((ReferenceRule)this.rule).allowedReferences()));
    }

    private boolean intersect(List<String> declarationTypes, List<String> allowedReferences) {
        for (int i = declarationTypes.size() - 1; i > -1; --i) {
            String str = declarationTypes.get(i);
            if (allowedReferences.remove(str)) continue;
            declarationTypes.remove(str);
        }
        return !declarationTypes.isEmpty();
    }

    private boolean areCompatibleReference(Node node) {
        return node != null && this.rule.accept(Collections.singletonList(new Primitive.Reference(node)));
    }

    @Override
    protected void error(Element element, Parameter parameter, ParameterConstraint.ParameterError errorType) throws SemanticException {
        switch (errorType) {
            case TYPE: {
                throw new SemanticException(new SemanticNotification(SemanticNotification.Level.ERROR, "reject.parameter.in.context", parameter, Arrays.asList(parameter.name(), this.allowedValues(", "))));
            }
            case NOT_FOUND: {
                throw new SemanticException(new SemanticNotification(SemanticNotification.Level.RECOVERABLE_ERROR, "required.parameter.in.context", element, Arrays.asList(this.name, "{" + this.allowedValues(", ") + "}")));
            }
            case RULE: {
                throw new SemanticException(new SemanticNotification(SemanticNotification.Level.ERROR, this.rule().errorMessage(), parameter, this.rule().errorParameters()));
            }
        }
    }

    private String allowedValues(String delimiter) {
        return this.rule() instanceof ReferenceRule ? String.join((CharSequence)delimiter, ((ReferenceRule)this.rule).allowedReferences()) : "";
    }

    public String toString() {
        return "Parameter{ref@" + this.name + "}";
    }
}

