/*
 * Decompiled with CFR 0.152.
 */
package io.intino.magritte.lang.semantics.constraints.flags;

import io.intino.magritte.lang.model.Node;
import io.intino.magritte.lang.model.Tag;
import io.intino.magritte.lang.semantics.constraints.flags.FlagChecker;
import io.intino.magritte.lang.semantics.errorcollector.SemanticException;
import io.intino.magritte.lang.semantics.errorcollector.SemanticNotification;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;

public class AnnotationCoherenceCheckerFactory {
    private static final Map<String, FlagChecker> checkers = new HashMap<String, FlagChecker>();

    private AnnotationCoherenceCheckerFactory() {
    }

    public static FlagChecker get(Object key) {
        return checkers.get(key.toString());
    }

    public static SemanticException error(Node node) {
        return new SemanticException(new SemanticNotification(SemanticNotification.Level.ERROR, "reject.flag.combination", node, Arrays.asList(Tag.Concept, Tag.Feature)));
    }

    static {
        checkers.put(Tag.Feature.name().toLowerCase(), new FeatureChecker());
    }

    private static class FeatureChecker
    implements FlagChecker {
        private FeatureChecker() {
        }

        @Override
        public void check(Node node) throws SemanticException {
            if ("Concept".equals(node.type())) {
                throw AnnotationCoherenceCheckerFactory.error(node);
            }
        }
    }
}

