/*
 * Decompiled with CFR 0.152.
 */
package io.intino.magritte.lang.semantics.constraints;

import io.intino.magritte.lang.model.Aspect;
import io.intino.magritte.lang.model.Element;
import io.intino.magritte.lang.model.Node;
import io.intino.magritte.lang.semantics.Constraint;
import io.intino.magritte.lang.semantics.errorcollector.SemanticException;
import io.intino.magritte.lang.semantics.errorcollector.SemanticNotification;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;

public class AspectConstraint
implements Constraint.Aspect {
    private final String type;
    private final boolean terminal;
    private final boolean required;
    private final String[] with;
    private final String[] withOut;
    private final List<Constraint> constraints;

    AspectConstraint(String type, boolean terminal, boolean required, String[] with, String[] withOut) {
        this.type = type;
        this.terminal = terminal;
        this.required = required;
        this.with = (String[])with.clone();
        this.withOut = (String[])withOut.clone();
        this.constraints = new ArrayList<Constraint>();
    }

    @Override
    public String type() {
        return this.type;
    }

    @Override
    public String[] with() {
        return this.with;
    }

    @Override
    public boolean isRequired() {
        return this.required;
    }

    @Override
    public String[] withOut() {
        return this.withOut;
    }

    @Override
    public boolean terminal() {
        return this.terminal;
    }

    @Override
    public List<Constraint> constraints() {
        return this.constraints;
    }

    @Override
    public Constraint.Aspect has(Constraint ... requires) {
        this.constraints.addAll(Arrays.asList(requires));
        return this;
    }

    @Override
    public void check(Element element) throws SemanticException {
        Node node = (Node)element;
        Aspect aspect = AspectConstraint.findAspect(node, this.type);
        if (aspect == null && this.required) {
            throw new SemanticException(new SemanticNotification(SemanticNotification.Level.ERROR, "reject.node.with.required.aspect.not.found", node, Collections.singletonList(this.type)));
        }
        if (aspect == null) {
            return;
        }
        boolean hasType = this.is(node.types(), this.with);
        boolean hasIncompatibles = this.isAny(node.types(), this.withOut);
        if (!hasType || hasIncompatibles || !this.checkAspectConstrains(node)) {
            if (!hasType) {
                throw new SemanticException(new SemanticNotification(SemanticNotification.Level.ERROR, "reject.aspect.with.no.constrains.in.context", aspect, Arrays.asList(this.with)));
            }
            if (hasIncompatibles) {
                throw new SemanticException(new SemanticNotification(SemanticNotification.Level.ERROR, "reject.incompatible.aspects.in.context", aspect, Collections.singletonList(String.join((CharSequence)", ", Arrays.asList(this.withOut)))));
            }
        }
    }

    public static Aspect findAspect(Node node, String type) {
        return node.appliedAspects().stream().filter(aspect -> type.equals(aspect.fullType())).findFirst().orElse(null);
    }

    private boolean is(List<String> nodeTypes, String[] constraints) {
        List types = nodeTypes.stream().map(s -> s.split(":")[0]).collect(Collectors.toList());
        if (constraints == null) {
            return true;
        }
        for (String aType : constraints) {
            if (types.contains(aType)) continue;
            return false;
        }
        return true;
    }

    private boolean isAny(List<String> nodeTypes, String[] constraints) {
        List types = nodeTypes.stream().map(s -> s.split(":")[0]).collect(Collectors.toList());
        if (constraints == null) {
            return false;
        }
        for (String aType : constraints) {
            if (!types.contains(aType) || aType.equals(this.type)) continue;
            return true;
        }
        return false;
    }

    private boolean checkAspectConstrains(Node node) throws SemanticException {
        ArrayList<SemanticException> messages = new ArrayList<SemanticException>();
        for (Constraint c : this.constraints) {
            try {
                c.check(node);
            }
            catch (SemanticException e) {
                if (e.level() == SemanticNotification.Level.ERROR) {
                    throw e;
                }
                messages.add(e);
            }
        }
        if (!messages.isEmpty()) {
            throw (SemanticException)messages.get(0);
        }
        return true;
    }

    public String toString() {
        return "Aspect " + this.type;
    }
}

