/*
 * Decompiled with CFR 0.152.
 */
package io.intino.magritte.framework.loaders;

import io.intino.magritte.framework.Layer;
import io.intino.magritte.framework.loaders.ListProcessor;
import java.time.LocalTime;
import java.time.format.DateTimeFormatter;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;

public class TimeLoader {
    private static final DateTimeFormatter[] dateFormats = new DateTimeFormatter[9];

    public static List<LocalTime> load(List<?> times, Layer layer) {
        return times.stream().map(item -> TimeLoader.processTime((String)item, layer)).collect(Collectors.toList());
    }

    private static LocalTime processTime(String time, Layer layer) {
        if (time.isEmpty()) {
            return null;
        }
        Object timeObject = ListProcessor.process((Object)time, layer);
        return timeObject instanceof LocalTime ? (LocalTime)timeObject : TimeLoader.parseTime(time);
    }

    private static LocalTime parseTime(String time) {
        if (time.length() < dateFormats.length && dateFormats[time.length()] != null) {
            return LocalTime.from(dateFormats[time.length()].parse(time));
        }
        throw new RuntimeException("Time couldn't be parsed: " + time);
    }

    static {
        String[] patterns = new String[]{"HH:mm:ss", "HH:mm", "HH"};
        Arrays.asList(patterns).forEach(p -> {
            TimeLoader.dateFormats[p.length()] = DateTimeFormatter.ofPattern(p);
        });
    }
}

