/*
 * Decompiled with CFR 0.152.
 */
package io.intino.magritte;

import io.intino.magritte.Language;
import io.intino.magritte.Resolver;
import io.intino.magritte.lang.model.Element;
import io.intino.magritte.lang.model.Node;
import io.intino.magritte.lang.semantics.Assumption;
import io.intino.magritte.lang.semantics.Constraint;
import io.intino.magritte.lang.semantics.constraints.AspectConstraint;
import io.intino.magritte.lang.semantics.errorcollector.SemanticException;
import io.intino.magritte.lang.semantics.errorcollector.SemanticFatalException;
import io.intino.magritte.lang.semantics.errorcollector.SemanticNotification;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;

public class Checker {
    private final Resolver resolver;
    private final Language language;
    private final List<SemanticException> exceptions = new ArrayList<SemanticException>();

    public Checker(Language language) {
        this.language = language;
        this.resolver = new Resolver(language);
    }

    public void check(Node node) throws SemanticFatalException {
        this.exceptions.clear();
        this.resolver.resolve(node);
        this.checkConstraints(node);
        if (!this.exceptions.isEmpty()) {
            this.recoverErrors();
            if (!this.exceptions.isEmpty()) {
                throw new SemanticFatalException(this.exceptions);
            }
        }
    }

    private void recoverErrors() {
        List toRemove = this.exceptions.stream().filter(e -> e.getNotification().key().equals("required.parameter.in.context") && this.isParameterNotFoundRecoverable(e.getNotification().origin()[0], e.getNotification().parameters().get(0).toString(), e.getNotification().parameters().get(1).toString())).collect(Collectors.toList());
        this.exceptions.removeAll(toRemove);
    }

    private boolean isParameterNotFoundRecoverable(Element element, String name, String type) {
        Node node = (Node)element;
        if (this.language == null) {
            return false;
        }
        List aspects = this.language.constraints(node.type()).stream().filter(c -> this.sameAspect(node, (Constraint)c)).map(c -> (Constraint.Aspect)c).collect(Collectors.toList());
        for (Constraint.Aspect aspect : aspects) {
            for (Constraint.Parameter c2 : aspect.constraints().stream().filter(c -> c instanceof Constraint.Parameter).map(p -> (Constraint.Parameter)p).collect(Collectors.toList())) {
                if (!c2.type().name().equalsIgnoreCase(type) || !c2.name().equals(name) || c2.size().isRequired()) continue;
                return true;
            }
        }
        return false;
    }

    private boolean sameAspect(Node node, Constraint c) {
        return c instanceof Constraint.Aspect && AspectConstraint.findAspect(node, ((Constraint.Aspect)c).type()) != null;
    }

    private void checkConstraints(Node node) throws SemanticFatalException {
        if (node == null) {
            throw new SemanticFatalException(new SemanticNotification(SemanticNotification.Level.ERROR, "Node is null", (Element)null));
        }
        this.assume(node);
        this.checkNodeConstrains(node);
    }

    private void assume(Node node) {
        if (node == null || node.type() == null || this.language == null) {
            return;
        }
        List<Assumption> assumptions = this.language.assumptions(node.type());
        if (assumptions != null) {
            this.assume(node, assumptions);
        }
        for (String type : node.secondaryTypes()) {
            assumptions = this.language.assumptions(type);
            if (assumptions == null) continue;
            this.assume(node, assumptions);
        }
    }

    private void assume(Node node, Collection<Assumption> assumptions) {
        for (Assumption assumption : assumptions) {
            assumption.assume(node);
        }
    }

    private void checkNodeConstrains(Node node) throws SemanticFatalException {
        List<Constraint> constraints = this.language.constraints(node.type());
        if (constraints == null) {
            this.finish(node);
        } else {
            for (Constraint constraint : constraints) {
                try {
                    constraint.check(node);
                }
                catch (SemanticException e) {
                    if (e.level() == SemanticNotification.Level.ERROR && e.isFatal()) {
                        throw new SemanticFatalException(Collections.singletonList(e));
                    }
                    this.exceptions.add(e);
                }
            }
        }
    }

    private void finish(Node node) throws SemanticFatalException {
        if (!node.isReference()) {
            throw new SemanticFatalException(new SemanticNotification(SemanticNotification.Level.ERROR, "reject.type.not.exists", node, Collections.singletonList(this.presentableType(node.type()))));
        }
    }

    private String presentableType(String type) {
        return type.replaceFirst(":", " on ");
    }
}

