/*
 * Decompiled with CFR 0.152.
 */
package io.intino.datahub.graph;

import io.intino.datahub.graph.Data;
import io.intino.datahub.graph.NessGraph;
import io.intino.magritte.framework.Layer;
import io.intino.magritte.framework.Node;
import io.intino.magritte.framework.loaders.IntegerLoader;
import io.intino.magritte.framework.loaders.ResourceLoader;
import io.intino.magritte.framework.loaders.StringLoader;
import io.intino.magritte.framework.tags.Terminal;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import java.util.stream.Collectors;

public class Wordbag
extends Layer
implements Terminal {
    protected Inline _inline;
    protected InResource _inResource;

    public Wordbag(Node node) {
        super(node);
    }

    public Inline asInline() {
        Inline as = this.a$(Inline.class);
        return as != null ? as : this.core$().addAspect(Inline.class);
    }

    public boolean isInline() {
        return this.core$().is(Inline.class);
    }

    public InResource asInResource() {
        return this.a$(InResource.class);
    }

    public InResource asInResource(URL tsv) {
        InResource newElement = this.core$().addAspect(InResource.class);
        newElement.core$().set(newElement, "tsv", Collections.singletonList(tsv));
        return newElement;
    }

    public boolean isInResource() {
        return this.core$().is(InResource.class);
    }

    public void removeInResource() {
        this.core$().removeAspect(InResource.class);
    }

    @Override
    protected Map<String, List<?>> variables$() {
        LinkedHashMap map = new LinkedHashMap();
        return map;
    }

    @Override
    protected void load$(String name, List<?> values) {
        super.load$(name, values);
    }

    @Override
    protected void set$(String name, List<?> values) {
        super.set$(name, values);
    }

    public Create create() {
        return new Create(null);
    }

    public Create create(String name) {
        return new Create(name);
    }

    public NessGraph graph() {
        return this.core$().graph().as(NessGraph.class);
    }

    public static class InResource
    extends Layer
    implements Terminal {
        protected URL tsv;
        protected List<Attribute> attributeList = new ArrayList<Attribute>();
        protected Wordbag _wordbag;

        public InResource(Node node) {
            super(node);
        }

        public URL tsv() {
            return this.tsv;
        }

        public InResource tsv(URL url, String destination) {
            this.tsv = url == null ? null : this.graph().core$().save(url, destination, this.tsv, this.core$());
            return this;
        }

        public InResource tsv(InputStream stream, String destination) {
            this.tsv = stream == null ? null : this.graph().core$().save(stream, destination, this.tsv, this.core$());
            return this;
        }

        public List<Attribute> attributeList() {
            return Collections.unmodifiableList(this.attributeList);
        }

        public Attribute attribute(int index) {
            return this.attributeList.get(index);
        }

        public List<Attribute> attributeList(Predicate<Attribute> predicate) {
            return this.attributeList().stream().filter(predicate).collect(Collectors.toList());
        }

        public Attribute attribute(Predicate<Attribute> predicate) {
            return this.attributeList().stream().filter(predicate).findFirst().orElse(null);
        }

        public Wordbag asWordbag() {
            return this.a$(Wordbag.class);
        }

        @Override
        protected List<Node> componentList$() {
            LinkedHashSet<Node> components = new LinkedHashSet<Node>(super.componentList$());
            new ArrayList<Attribute>(this.attributeList).forEach(c -> components.add(c.core$()));
            return new ArrayList<Node>(components);
        }

        @Override
        protected Map<String, List<?>> variables$() {
            LinkedHashMap map = new LinkedHashMap();
            map.put("tsv", new ArrayList<URL>(Collections.singletonList(this.tsv)));
            return map;
        }

        @Override
        protected void addNode$(Node node) {
            super.addNode$(node);
            if (node.is("Wordbag$InResource$Attribute")) {
                this.attributeList.add(node.as(Attribute.class));
            }
        }

        @Override
        protected void removeNode$(Node node) {
            super.removeNode$(node);
            if (node.is("Wordbag$InResource$Attribute")) {
                this.attributeList.remove(node.as(Attribute.class));
            }
        }

        @Override
        protected void load$(String name, List<?> values) {
            super.load$(name, values);
            if (name.equalsIgnoreCase("tsv")) {
                this.tsv = ResourceLoader.load(values, this).get(0);
            }
        }

        @Override
        protected void set$(String name, List<?> values) {
            super.set$(name, values);
            if (name.equalsIgnoreCase("tsv")) {
                this.tsv = (URL)values.get(0);
            }
        }

        @Override
        protected void sync$(Layer layer) {
            super.sync$(layer);
            if (layer instanceof Wordbag) {
                this._wordbag = (Wordbag)layer;
            }
        }

        public Create create() {
            return new Create(null);
        }

        public Create create(String name) {
            return new Create(name);
        }

        public Clear clear() {
            return new Clear();
        }

        public NessGraph graph() {
            return this.core$().graph().as(NessGraph.class);
        }

        public static class Attribute
        extends Data
        implements Terminal {
            public Attribute(Node node) {
                super(node);
            }

            @Override
            protected Map<String, List<?>> variables$() {
                LinkedHashMap map = new LinkedHashMap(super.variables$());
                return map;
            }

            @Override
            protected void load$(String name, List<?> values) {
                super.load$(name, values);
            }

            @Override
            protected void set$(String name, List<?> values) {
                super.set$(name, values);
            }

            @Override
            public NessGraph graph() {
                return this.core$().graph().as(NessGraph.class);
            }
        }

        public class Clear {
            public void attribute(Predicate<Attribute> filter) {
                new ArrayList<Attribute>(InResource.this.attributeList()).stream().filter(filter).forEach(Layer::delete$);
            }
        }

        public class Create {
            protected final String name;

            public Create(String name) {
                this.name = name;
            }

            public Attribute attribute() {
                Attribute newElement = InResource.this.core$().graph().concept(Attribute.class).createNode(this.name, InResource.this.core$()).as(Attribute.class);
                return newElement;
            }
        }
    }

    public static class Inline
    extends Layer
    implements Terminal {
        protected List<Word> wordList = new ArrayList<Word>();
        protected Wordbag _wordbag;

        public Inline(Node node) {
            super(node);
        }

        public List<Word> wordList() {
            return Collections.unmodifiableList(this.wordList);
        }

        public Word word(int index) {
            return this.wordList.get(index);
        }

        public List<Word> wordList(Predicate<Word> predicate) {
            return this.wordList().stream().filter(predicate).collect(Collectors.toList());
        }

        public Word word(Predicate<Word> predicate) {
            return this.wordList().stream().filter(predicate).findFirst().orElse(null);
        }

        public Wordbag asWordbag() {
            return this.a$(Wordbag.class);
        }

        @Override
        protected List<Node> componentList$() {
            LinkedHashSet<Node> components = new LinkedHashSet<Node>(super.componentList$());
            new ArrayList<Word>(this.wordList).forEach(c -> components.add(c.core$()));
            return new ArrayList<Node>(components);
        }

        @Override
        protected Map<String, List<?>> variables$() {
            LinkedHashMap map = new LinkedHashMap();
            return map;
        }

        @Override
        protected void addNode$(Node node) {
            super.addNode$(node);
            if (node.is("Wordbag$Inline$Word")) {
                this.wordList.add(node.as(Word.class));
            }
        }

        @Override
        protected void removeNode$(Node node) {
            super.removeNode$(node);
            if (node.is("Wordbag$Inline$Word")) {
                this.wordList.remove(node.as(Word.class));
            }
        }

        @Override
        protected void load$(String name, List<?> values) {
            super.load$(name, values);
        }

        @Override
        protected void set$(String name, List<?> values) {
            super.set$(name, values);
        }

        @Override
        protected void sync$(Layer layer) {
            super.sync$(layer);
            if (layer instanceof Wordbag) {
                this._wordbag = (Wordbag)layer;
            }
        }

        public Create create() {
            return new Create(null);
        }

        public Create create(String name) {
            return new Create(name);
        }

        public Clear clear() {
            return new Clear();
        }

        public NessGraph graph() {
            return this.core$().graph().as(NessGraph.class);
        }

        public static class Word
        extends Layer
        implements Terminal {
            protected int value;
            protected String label;

            public Word(Node node) {
                super(node);
            }

            public int value() {
                return this.value;
            }

            public String label() {
                return this.label;
            }

            public Word value(int value) {
                this.value = value;
                return this;
            }

            public Word label(String value) {
                this.label = value;
                return this;
            }

            @Override
            protected Map<String, List<?>> variables$() {
                LinkedHashMap map = new LinkedHashMap();
                map.put("value", new ArrayList<Integer>(Collections.singletonList(this.value)));
                map.put("label", new ArrayList<String>(Collections.singletonList(this.label)));
                return map;
            }

            @Override
            protected void load$(String name, List<?> values) {
                super.load$(name, values);
                if (name.equalsIgnoreCase("value")) {
                    this.value = IntegerLoader.load(values, this).get(0);
                } else if (name.equalsIgnoreCase("label")) {
                    this.label = StringLoader.load(values, this).get(0);
                }
            }

            @Override
            protected void set$(String name, List<?> values) {
                super.set$(name, values);
                if (name.equalsIgnoreCase("value")) {
                    this.value = (Integer)values.get(0);
                } else if (name.equalsIgnoreCase("label")) {
                    this.label = (String)values.get(0);
                }
            }

            public NessGraph graph() {
                return this.core$().graph().as(NessGraph.class);
            }
        }

        public class Clear {
            public void word(Predicate<Word> filter) {
                new ArrayList<Word>(Inline.this.wordList()).stream().filter(filter).forEach(Layer::delete$);
            }
        }

        public class Create {
            protected final String name;

            public Create(String name) {
                this.name = name;
            }

            public Word word(int value) {
                Word newElement = Inline.this.core$().graph().concept(Word.class).createNode(this.name, Inline.this.core$()).as(Word.class);
                newElement.core$().set(newElement, "value", Collections.singletonList(value));
                return newElement;
            }
        }
    }

    public class Create {
        protected final String name;

        public Create(String name) {
            this.name = name;
        }
    }
}

