/*
 * Decompiled with CFR 0.152.
 */
package io.intino.datahub.graph;

import io.intino.datahub.graph.Data;
import io.intino.datahub.graph.NessGraph;
import io.intino.magritte.framework.Layer;
import io.intino.magritte.framework.Node;
import io.intino.magritte.framework.loaders.BooleanLoader;
import io.intino.magritte.framework.loaders.NodeLoader;
import io.intino.magritte.framework.loaders.StringLoader;
import io.intino.magritte.framework.tags.Terminal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import java.util.stream.Collectors;

public class Lookup
extends Layer
implements Terminal {
    protected String namespace;
    protected List<Column> columnList = new ArrayList<Column>();
    protected List<Index> indexList = new ArrayList<Index>();
    protected Volatile _volatile;

    public Lookup(Node node) {
        super(node);
    }

    public String namespace() {
        return this.namespace;
    }

    public Lookup namespace(String value) {
        this.namespace = value;
        return this;
    }

    public List<Column> columnList() {
        return Collections.unmodifiableList(this.columnList);
    }

    public Column column(int index) {
        return this.columnList.get(index);
    }

    public List<Column> columnList(Predicate<Column> predicate) {
        return this.columnList().stream().filter(predicate).collect(Collectors.toList());
    }

    public Column column(Predicate<Column> predicate) {
        return this.columnList().stream().filter(predicate).findFirst().orElse(null);
    }

    public List<Index> indexList() {
        return Collections.unmodifiableList(this.indexList);
    }

    public Index index(int index) {
        return this.indexList.get(index);
    }

    public List<Index> indexList(Predicate<Index> predicate) {
        return this.indexList().stream().filter(predicate).collect(Collectors.toList());
    }

    public Index index(Predicate<Index> predicate) {
        return this.indexList().stream().filter(predicate).findFirst().orElse(null);
    }

    public Volatile asVolatile() {
        Volatile as = this.a$(Volatile.class);
        return as != null ? as : this.core$().addAspect(Volatile.class);
    }

    public boolean isVolatile() {
        return this.core$().is(Volatile.class);
    }

    @Override
    protected List<Node> componentList$() {
        LinkedHashSet<Node> components = new LinkedHashSet<Node>(super.componentList$());
        new ArrayList<Column>(this.columnList).forEach(c -> components.add(c.core$()));
        new ArrayList<Index>(this.indexList).forEach(c -> components.add(c.core$()));
        return new ArrayList<Node>(components);
    }

    @Override
    protected Map<String, List<?>> variables$() {
        LinkedHashMap map = new LinkedHashMap();
        map.put("namespace", new ArrayList<String>(Collections.singletonList(this.namespace)));
        return map;
    }

    @Override
    protected void addNode$(Node node) {
        super.addNode$(node);
        if (node.is("Lookup$Column")) {
            this.columnList.add(node.as(Column.class));
        }
        if (node.is("Lookup$Index")) {
            this.indexList.add(node.as(Index.class));
        }
    }

    @Override
    protected void removeNode$(Node node) {
        super.removeNode$(node);
        if (node.is("Lookup$Column")) {
            this.columnList.remove(node.as(Column.class));
        }
        if (node.is("Lookup$Index")) {
            this.indexList.remove(node.as(Index.class));
        }
    }

    @Override
    protected void load$(String name, List<?> values) {
        super.load$(name, values);
        if (name.equalsIgnoreCase("namespace")) {
            this.namespace = StringLoader.load(values, this).get(0);
        }
    }

    @Override
    protected void set$(String name, List<?> values) {
        super.set$(name, values);
        if (name.equalsIgnoreCase("namespace")) {
            this.namespace = (String)values.get(0);
        }
    }

    public Create create() {
        return new Create(null);
    }

    public Create create(String name) {
        return new Create(name);
    }

    public Clear clear() {
        return new Clear();
    }

    public NessGraph graph() {
        return this.core$().graph().as(NessGraph.class);
    }

    public static class Volatile
    extends Layer
    implements Terminal {
        protected Lookup _lookup;

        public Volatile(Node node) {
            super(node);
        }

        public String namespace() {
            return this._lookup.namespace();
        }

        public Volatile namespace(String value) {
            this._lookup.namespace(value);
            return this;
        }

        public List<Column> columnList() {
            return this._lookup.columnList();
        }

        public Column columnList(int index) {
            return this._lookup.columnList().get(index);
        }

        public List<Index> indexList() {
            return this._lookup.indexList();
        }

        public Index indexList(int index) {
            return this._lookup.indexList().get(index);
        }

        public Lookup asLookup() {
            return this.a$(Lookup.class);
        }

        @Override
        protected Map<String, List<?>> variables$() {
            LinkedHashMap map = new LinkedHashMap();
            return map;
        }

        @Override
        protected void load$(String name, List<?> values) {
            super.load$(name, values);
        }

        @Override
        protected void set$(String name, List<?> values) {
            super.set$(name, values);
        }

        @Override
        protected void sync$(Layer layer) {
            super.sync$(layer);
            if (layer instanceof Lookup) {
                this._lookup = (Lookup)layer;
            }
        }

        public Create create() {
            return new Create(null);
        }

        public Create create(String name) {
            return new Create(name);
        }

        public Clear clear() {
            return new Clear();
        }

        public NessGraph graph() {
            return this.core$().graph().as(NessGraph.class);
        }

        public class Clear {
            public void column(Predicate<Column> filter) {
                new ArrayList<Column>(Volatile.this.columnList()).stream().filter(filter).forEach(Layer::delete$);
            }

            public void index(Predicate<Index> filter) {
                new ArrayList<Index>(Volatile.this.indexList()).stream().filter(filter).forEach(Layer::delete$);
            }
        }

        public class Create {
            protected final String name;

            public Create(String name) {
                this.name = name;
            }

            public Column column() {
                Column newElement = Volatile.this.core$().graph().concept(Column.class).createNode(this.name, Volatile.this.core$()).as(Column.class);
                return newElement;
            }

            public Index index(List<Column> columns) {
                Index newElement = Volatile.this.core$().graph().concept(Index.class).createNode(this.name, Volatile.this.core$()).as(Index.class);
                newElement.core$().set(newElement, "columns", columns);
                return newElement;
            }
        }
    }

    public static class Index
    extends Layer
    implements Terminal {
        protected List<Column> columns = new ArrayList<Column>();
        protected boolean createOnClose;

        public Index(Node node) {
            super(node);
        }

        public List<Column> columns() {
            return this.columns;
        }

        public Column columns(int index) {
            return this.columns.get(index);
        }

        public List<Column> columns(Predicate<Column> predicate) {
            return this.columns().stream().filter(predicate).collect(Collectors.toList());
        }

        public boolean createOnClose() {
            return this.createOnClose;
        }

        public Index createOnClose(boolean value) {
            this.createOnClose = value;
            return this;
        }

        @Override
        protected Map<String, List<?>> variables$() {
            LinkedHashMap map = new LinkedHashMap();
            map.put("columns", this.columns);
            map.put("createOnClose", new ArrayList<Boolean>(Collections.singletonList(this.createOnClose)));
            return map;
        }

        @Override
        protected void load$(String name, List<?> values) {
            super.load$(name, values);
            if (name.equalsIgnoreCase("columns")) {
                this.columns = NodeLoader.load(values, Column.class, this);
            } else if (name.equalsIgnoreCase("createOnClose")) {
                this.createOnClose = BooleanLoader.load(values, this).get(0);
            }
        }

        @Override
        protected void set$(String name, List<?> values) {
            super.set$(name, values);
            if (name.equalsIgnoreCase("columns")) {
                this.columns = values.stream().map(s -> this.graph().core$().load(((Layer)s).core$().id()).as(Column.class)).collect(Collectors.toList());
            } else if (name.equalsIgnoreCase("createOnClose")) {
                this.createOnClose = (Boolean)values.get(0);
            }
        }

        public NessGraph graph() {
            return this.core$().graph().as(NessGraph.class);
        }
    }

    public static class Column
    extends Data
    implements Terminal {
        protected boolean isRequired;

        public Column(Node node) {
            super(node);
        }

        public boolean isRequired() {
            return this.isRequired;
        }

        public Column isRequired(boolean value) {
            this.isRequired = value;
            return this;
        }

        @Override
        protected Map<String, List<?>> variables$() {
            LinkedHashMap map = new LinkedHashMap(super.variables$());
            map.put("isRequired", new ArrayList<Boolean>(Collections.singletonList(this.isRequired)));
            return map;
        }

        @Override
        protected void load$(String name, List<?> values) {
            super.load$(name, values);
            if (name.equalsIgnoreCase("isRequired")) {
                this.isRequired = BooleanLoader.load(values, this).get(0);
            }
        }

        @Override
        protected void set$(String name, List<?> values) {
            super.set$(name, values);
            if (name.equalsIgnoreCase("isRequired")) {
                this.isRequired = (Boolean)values.get(0);
            }
        }

        @Override
        public NessGraph graph() {
            return this.core$().graph().as(NessGraph.class);
        }
    }

    public class Clear {
        public void column(Predicate<Column> filter) {
            new ArrayList<Column>(Lookup.this.columnList()).stream().filter(filter).forEach(Layer::delete$);
        }

        public void index(Predicate<Index> filter) {
            new ArrayList<Index>(Lookup.this.indexList()).stream().filter(filter).forEach(Layer::delete$);
        }
    }

    public class Create {
        protected final String name;

        public Create(String name) {
            this.name = name;
        }

        public Column column() {
            Column newElement = Lookup.this.core$().graph().concept(Column.class).createNode(this.name, Lookup.this.core$()).as(Column.class);
            return newElement;
        }

        public Index index(List<Column> columns) {
            Index newElement = Lookup.this.core$().graph().concept(Index.class).createNode(this.name, Lookup.this.core$()).as(Index.class);
            newElement.core$().set(newElement, "columns", columns);
            return newElement;
        }
    }
}

