/*
 * Decompiled with CFR 0.152.
 */
package io.intino.datahub.graph;

import io.intino.datahub.graph.Event;
import io.intino.datahub.graph.NessGraph;
import io.intino.datahub.graph.rules.Scale;
import io.intino.magritte.framework.Expression;
import io.intino.magritte.framework.Layer;
import io.intino.magritte.framework.Node;
import io.intino.magritte.framework.loaders.BooleanLoader;
import io.intino.magritte.framework.loaders.FunctionLoader;
import io.intino.magritte.framework.loaders.NodeLoader;
import io.intino.magritte.framework.loaders.StringLoader;
import io.intino.magritte.framework.loaders.WordLoader;
import io.intino.magritte.framework.tags.Terminal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import java.util.stream.Collectors;

public class Datalake
extends Layer
implements Terminal {
    protected Scale scale;
    protected String path;
    protected Backup backup;
    protected Seal seal;
    protected ProcessStatus processStatus;
    protected List<Split> splitList = new ArrayList<Split>();
    protected List<Tank> tankList = new ArrayList<Tank>();

    public Datalake(Node node) {
        super(node);
    }

    public Scale scale() {
        return this.scale;
    }

    public String path() {
        return this.path;
    }

    public Datalake scale(Scale value) {
        this.scale = value;
        return this;
    }

    public Datalake path(String value) {
        this.path = value;
        return this;
    }

    public Backup backup() {
        return this.backup;
    }

    public Seal seal() {
        return this.seal;
    }

    public ProcessStatus processStatus() {
        return this.processStatus;
    }

    public List<Split> splitList() {
        return Collections.unmodifiableList(this.splitList);
    }

    public Split split(int index) {
        return this.splitList.get(index);
    }

    public List<Split> splitList(Predicate<Split> predicate) {
        return this.splitList().stream().filter(predicate).collect(Collectors.toList());
    }

    public Split split(Predicate<Split> predicate) {
        return this.splitList().stream().filter(predicate).findFirst().orElse(null);
    }

    public List<Tank> tankList() {
        return Collections.unmodifiableList(this.tankList);
    }

    public Tank tank(int index) {
        return this.tankList.get(index);
    }

    public List<Tank> tankList(Predicate<Tank> predicate) {
        return this.tankList().stream().filter(predicate).collect(Collectors.toList());
    }

    public Tank tank(Predicate<Tank> predicate) {
        return this.tankList().stream().filter(predicate).findFirst().orElse(null);
    }

    @Override
    protected List<Node> componentList$() {
        LinkedHashSet<Node> components = new LinkedHashSet<Node>(super.componentList$());
        if (this.backup != null) {
            components.add(this.backup.core$());
        }
        if (this.seal != null) {
            components.add(this.seal.core$());
        }
        if (this.processStatus != null) {
            components.add(this.processStatus.core$());
        }
        new ArrayList<Split>(this.splitList).forEach(c -> components.add(c.core$()));
        new ArrayList<Tank>(this.tankList).forEach(c -> components.add(c.core$()));
        return new ArrayList<Node>(components);
    }

    @Override
    protected Map<String, List<?>> variables$() {
        LinkedHashMap map = new LinkedHashMap();
        map.put("scale", new ArrayList<Scale>(Collections.singletonList(this.scale)));
        map.put("path", new ArrayList<String>(Collections.singletonList(this.path)));
        return map;
    }

    @Override
    protected void addNode$(Node node) {
        super.addNode$(node);
        if (node.is("Datalake$Backup")) {
            this.backup = node.as(Backup.class);
        }
        if (node.is("Datalake$Seal")) {
            this.seal = node.as(Seal.class);
        }
        if (node.is("Datalake$ProcessStatus")) {
            this.processStatus = node.as(ProcessStatus.class);
        }
        if (node.is("Datalake$Split")) {
            this.splitList.add(node.as(Split.class));
        }
        if (node.is("Datalake$Tank")) {
            this.tankList.add(node.as(Tank.class));
        }
    }

    @Override
    protected void removeNode$(Node node) {
        super.removeNode$(node);
        if (node.is("Datalake$Backup")) {
            this.backup = null;
        }
        if (node.is("Datalake$Seal")) {
            this.seal = null;
        }
        if (node.is("Datalake$ProcessStatus")) {
            this.processStatus = null;
        }
        if (node.is("Datalake$Split")) {
            this.splitList.remove(node.as(Split.class));
        }
        if (node.is("Datalake$Tank")) {
            this.tankList.remove(node.as(Tank.class));
        }
    }

    @Override
    protected void load$(String name, List<?> values) {
        super.load$(name, values);
        if (name.equalsIgnoreCase("scale")) {
            this.scale = WordLoader.load(values, Scale.class, this).get(0);
        } else if (name.equalsIgnoreCase("path")) {
            this.path = StringLoader.load(values, this).get(0);
        }
    }

    @Override
    protected void set$(String name, List<?> values) {
        super.set$(name, values);
        if (name.equalsIgnoreCase("scale")) {
            this.scale = (Scale)values.get(0);
        } else if (name.equalsIgnoreCase("path")) {
            this.path = (String)values.get(0);
        }
    }

    public Create create() {
        return new Create(null);
    }

    public Create create(String name) {
        return new Create(name);
    }

    public Clear clear() {
        return new Clear();
    }

    public NessGraph graph() {
        return this.core$().graph().as(NessGraph.class);
    }

    public static class Tank
    extends Layer
    implements Terminal {
        protected Scale scale;
        protected TankType _tankType;
        protected Set _set;
        protected Event _event;
        protected Splitted _splitted;

        public Tank(Node node) {
            super(node);
        }

        public Scale scale() {
            return this.scale;
        }

        public Tank scale(Scale value) {
            this.scale = value;
            return this;
        }

        public Splitted asSplitted() {
            return this.a$(Splitted.class);
        }

        public Splitted asSplitted(Split split) {
            Splitted newElement = this.core$().addAspect(Splitted.class);
            newElement.core$().set(newElement, "split", Collections.singletonList(split));
            return newElement;
        }

        public boolean isSplitted() {
            return this.core$().is(Splitted.class);
        }

        public void removeSplitted() {
            this.core$().removeAspect(Splitted.class);
        }

        public TankType asTankType() {
            TankType as = this.a$(TankType.class);
            return as != null ? as : this.core$().addAspect(TankType.class);
        }

        public boolean isTankType() {
            return this.core$().is(TankType.class);
        }

        public Event asEvent() {
            return this.a$(Event.class);
        }

        public Event asEvent(io.intino.datahub.graph.Event event) {
            Event newElement = this.core$().addAspect(Event.class);
            newElement.core$().set(newElement, "event", Collections.singletonList(event));
            return newElement;
        }

        public boolean isEvent() {
            return this.core$().is(Event.class);
        }

        public void removeEvent() {
            this.core$().removeAspect(Event.class);
        }

        public Set asSet() {
            return this.a$(Set.class);
        }

        public Set asSet(String tank) {
            Set newElement = this.core$().addAspect(Set.class);
            newElement.core$().set(newElement, "tank", Collections.singletonList(tank));
            return newElement;
        }

        public boolean isSet() {
            return this.core$().is(Set.class);
        }

        public void removeSet() {
            this.core$().removeAspect(Set.class);
        }

        @Override
        protected Map<String, List<?>> variables$() {
            LinkedHashMap map = new LinkedHashMap();
            map.put("scale", new ArrayList<Scale>(Collections.singletonList(this.scale)));
            return map;
        }

        @Override
        protected void load$(String name, List<?> values) {
            super.load$(name, values);
            if (name.equalsIgnoreCase("scale")) {
                this.scale = WordLoader.load(values, Scale.class, this).get(0);
            }
        }

        @Override
        protected void set$(String name, List<?> values) {
            super.set$(name, values);
            if (name.equalsIgnoreCase("scale")) {
                this.scale = (Scale)values.get(0);
            }
        }

        public Create create() {
            return new Create(null);
        }

        public Create create(String name) {
            return new Create(name);
        }

        public NessGraph graph() {
            return this.core$().graph().as(NessGraph.class);
        }

        public static class Splitted
        extends Layer
        implements Terminal {
            protected Split split;
            protected Tank _tank;

            public Splitted(Node node) {
                super(node);
            }

            public Split split() {
                return this.split;
            }

            public Scale scale() {
                return this._tank.scale();
            }

            public Splitted split(Split value) {
                this.split = value;
                return this;
            }

            public Splitted scale(Scale value) {
                this._tank.scale(value);
                return this;
            }

            public Tank asTank() {
                return this.a$(Tank.class);
            }

            @Override
            protected Map<String, List<?>> variables$() {
                LinkedHashMap map = new LinkedHashMap();
                map.put("split", this.split != null ? new ArrayList<Split>(Collections.singletonList(this.split)) : Collections.emptyList());
                return map;
            }

            @Override
            protected void load$(String name, List<?> values) {
                super.load$(name, values);
                if (name.equalsIgnoreCase("split")) {
                    this.split = NodeLoader.load(values, Split.class, this).get(0);
                }
            }

            @Override
            protected void set$(String name, List<?> values) {
                super.set$(name, values);
                if (name.equalsIgnoreCase("split")) {
                    this.split = values.get(0) != null ? this.core$().graph().load(((Layer)values.get(0)).core$().id()).as(Split.class) : null;
                }
            }

            @Override
            protected void sync$(Layer layer) {
                super.sync$(layer);
                if (layer instanceof Tank) {
                    this._tank = (Tank)layer;
                }
            }

            public NessGraph graph() {
                return this.core$().graph().as(NessGraph.class);
            }
        }

        public static class Event
        extends TankType
        implements Terminal {
            protected io.intino.datahub.graph.Event event;
            protected boolean sortingRequired;
            protected Expression<String> qn;

            public Event(Node node) {
                super(node);
            }

            public io.intino.datahub.graph.Event event() {
                return this.event;
            }

            public boolean sortingRequired() {
                return this.sortingRequired;
            }

            public String qn() {
                return this.qn.value();
            }

            @Override
            public Scale scale() {
                return this._tank.scale();
            }

            public Event event(io.intino.datahub.graph.Event value) {
                this.event = value;
                return this;
            }

            public Event sortingRequired(boolean value) {
                this.sortingRequired = value;
                return this;
            }

            public Event qn(Expression<String> value) {
                this.qn = FunctionLoader.load(value, (Layer)this, Expression.class);
                return this;
            }

            @Override
            public Event scale(Scale value) {
                this._tank.scale(value);
                return this;
            }

            @Override
            public Tank asTank() {
                return this.a$(Tank.class);
            }

            @Override
            protected Map<String, List<?>> variables$() {
                LinkedHashMap map = new LinkedHashMap(super.variables$());
                map.put("event", this.event != null ? new ArrayList<io.intino.datahub.graph.Event>(Collections.singletonList(this.event)) : Collections.emptyList());
                map.put("sortingRequired", new ArrayList<Boolean>(Collections.singletonList(this.sortingRequired)));
                map.put("qn", new ArrayList<Expression<String>>(Collections.singletonList(this.qn)));
                return map;
            }

            @Override
            protected void load$(String name, List<?> values) {
                super.load$(name, values);
                this._tank.core$().load(this._tank, name, values);
                if (name.equalsIgnoreCase("event")) {
                    this.event = NodeLoader.load(values, io.intino.datahub.graph.Event.class, this).get(0);
                } else if (name.equalsIgnoreCase("sortingRequired")) {
                    this.sortingRequired = BooleanLoader.load(values, this).get(0);
                } else if (name.equalsIgnoreCase("qn")) {
                    this.qn = FunctionLoader.load(values, (Layer)this, Expression.class).get(0);
                }
            }

            @Override
            protected void set$(String name, List<?> values) {
                super.set$(name, values);
                this._tank.core$().set(this._tank, name, values);
                if (name.equalsIgnoreCase("event")) {
                    this.event = values.get(0) != null ? this.core$().graph().load(((Layer)values.get(0)).core$().id()).as(io.intino.datahub.graph.Event.class) : null;
                } else if (name.equalsIgnoreCase("sortingRequired")) {
                    this.sortingRequired = (Boolean)values.get(0);
                } else if (name.equalsIgnoreCase("qn")) {
                    this.qn = FunctionLoader.load(values.get(0), (Layer)this, Expression.class);
                }
            }

            @Override
            public NessGraph graph() {
                return this.core$().graph().as(NessGraph.class);
            }
        }

        public static class Set
        extends TankType
        implements Terminal {
            protected String tank;
            protected Type type;

            public Set(Node node) {
                super(node);
            }

            public String tank() {
                return this.tank;
            }

            public Type type() {
                return this.type;
            }

            @Override
            public Scale scale() {
                return this._tank.scale();
            }

            public Set tank(String value) {
                this.tank = value;
                return this;
            }

            public Set type(Type value) {
                this.type = value;
                return this;
            }

            @Override
            public Set scale(Scale value) {
                this._tank.scale(value);
                return this;
            }

            @Override
            public Tank asTank() {
                return this.a$(Tank.class);
            }

            @Override
            protected Map<String, List<?>> variables$() {
                LinkedHashMap map = new LinkedHashMap(super.variables$());
                map.put("tank", new ArrayList<String>(Collections.singletonList(this.tank)));
                map.put("type", new ArrayList<Type>(Collections.singletonList(this.type)));
                return map;
            }

            @Override
            protected void load$(String name, List<?> values) {
                super.load$(name, values);
                this._tank.core$().load(this._tank, name, values);
                if (name.equalsIgnoreCase("tank")) {
                    this.tank = StringLoader.load(values, this).get(0);
                } else if (name.equalsIgnoreCase("type")) {
                    this.type = WordLoader.load(values, Type.class, this).get(0);
                }
            }

            @Override
            protected void set$(String name, List<?> values) {
                super.set$(name, values);
                this._tank.core$().set(this._tank, name, values);
                if (name.equalsIgnoreCase("tank")) {
                    this.tank = (String)values.get(0);
                } else if (name.equalsIgnoreCase("type")) {
                    this.type = (Type)((Object)values.get(0));
                }
            }

            @Override
            public NessGraph graph() {
                return this.core$().graph().as(NessGraph.class);
            }

            public static enum Type {
                Multivalued,
                Singleton;

            }
        }

        public static abstract class TankType
        extends Layer
        implements Terminal {
            protected Tank _tank;

            public TankType(Node node) {
                super(node);
            }

            public Scale scale() {
                return this._tank.scale();
            }

            public TankType scale(Scale value) {
                this._tank.scale(value);
                return this;
            }

            public Tank asTank() {
                return this.a$(Tank.class);
            }

            @Override
            protected Map<String, List<?>> variables$() {
                LinkedHashMap map = new LinkedHashMap();
                return map;
            }

            @Override
            protected void load$(String name, List<?> values) {
                super.load$(name, values);
            }

            @Override
            protected void set$(String name, List<?> values) {
                super.set$(name, values);
            }

            @Override
            protected void sync$(Layer layer) {
                super.sync$(layer);
                if (layer instanceof Tank) {
                    this._tank = (Tank)layer;
                }
            }

            public Create create() {
                return new Create(null);
            }

            public Create create(String name) {
                return new Create(name);
            }

            public NessGraph graph() {
                return this.core$().graph().as(NessGraph.class);
            }

            public class Create {
                protected final String name;

                public Create(String name) {
                    this.name = name;
                }
            }
        }

        public class Create {
            protected final String name;

            public Create(String name) {
                this.name = name;
            }
        }
    }

    public static class Split
    extends Layer
    implements Terminal {
        protected String label;
        protected Expression<String> qn;
        protected Expression<Boolean> isLeaf;
        protected Expression<Boolean> isRoot;
        protected Expression<List<Split>> leafs;
        protected List<Split> splitList = new ArrayList<Split>();

        public Split(Node node) {
            super(node);
        }

        public String label() {
            return this.label;
        }

        public String qn() {
            return this.qn.value();
        }

        public Boolean isLeaf() {
            return this.isLeaf.value();
        }

        public Boolean isRoot() {
            return this.isRoot.value();
        }

        public List<Split> leafs() {
            return this.leafs.value();
        }

        public Split label(String value) {
            this.label = value;
            return this;
        }

        public Split qn(Expression<String> value) {
            this.qn = FunctionLoader.load(value, (Layer)this, Expression.class);
            return this;
        }

        public Split isLeaf(Expression<Boolean> value) {
            this.isLeaf = FunctionLoader.load(value, (Layer)this, Expression.class);
            return this;
        }

        public Split isRoot(Expression<Boolean> value) {
            this.isRoot = FunctionLoader.load(value, (Layer)this, Expression.class);
            return this;
        }

        public List<Split> splitList() {
            return Collections.unmodifiableList(this.splitList);
        }

        public Split split(int index) {
            return this.splitList.get(index);
        }

        public List<Split> splitList(Predicate<Split> predicate) {
            return this.splitList().stream().filter(predicate).collect(Collectors.toList());
        }

        public Split split(Predicate<Split> predicate) {
            return this.splitList().stream().filter(predicate).findFirst().orElse(null);
        }

        @Override
        protected List<Node> componentList$() {
            LinkedHashSet<Node> components = new LinkedHashSet<Node>(super.componentList$());
            new ArrayList<Split>(this.splitList).forEach(c -> components.add(c.core$()));
            return new ArrayList<Node>(components);
        }

        @Override
        protected Map<String, List<?>> variables$() {
            LinkedHashMap map = new LinkedHashMap();
            map.put("label", new ArrayList<String>(Collections.singletonList(this.label)));
            map.put("qn", new ArrayList<Expression<String>>(Collections.singletonList(this.qn)));
            map.put("isLeaf", new ArrayList<Expression<Boolean>>(Collections.singletonList(this.isLeaf)));
            map.put("isRoot", new ArrayList<Expression<Boolean>>(Collections.singletonList(this.isRoot)));
            map.put("leafs", this.leafs != null ? new ArrayList<Expression<List<Split>>>(Collections.singletonList(this.leafs)) : Collections.emptyList());
            return map;
        }

        @Override
        protected void addNode$(Node node) {
            super.addNode$(node);
            if (node.is("Datalake$Split")) {
                this.splitList.add(node.as(Split.class));
            }
        }

        @Override
        protected void removeNode$(Node node) {
            super.removeNode$(node);
            if (node.is("Datalake$Split")) {
                this.splitList.remove(node.as(Split.class));
            }
        }

        @Override
        protected void load$(String name, List<?> values) {
            super.load$(name, values);
            if (name.equalsIgnoreCase("label")) {
                this.label = StringLoader.load(values, this).get(0);
            } else if (name.equalsIgnoreCase("qn")) {
                this.qn = FunctionLoader.load(values, (Layer)this, Expression.class).get(0);
            } else if (name.equalsIgnoreCase("isLeaf")) {
                this.isLeaf = FunctionLoader.load(values, (Layer)this, Expression.class).get(0);
            } else if (name.equalsIgnoreCase("isRoot")) {
                this.isRoot = FunctionLoader.load(values, (Layer)this, Expression.class).get(0);
            } else if (name.equalsIgnoreCase("leafs")) {
                this.leafs = FunctionLoader.load(values, (Layer)this, Expression.class).get(0);
            }
        }

        @Override
        protected void set$(String name, List<?> values) {
            super.set$(name, values);
            if (name.equalsIgnoreCase("label")) {
                this.label = (String)values.get(0);
            } else if (name.equalsIgnoreCase("qn")) {
                this.qn = FunctionLoader.load(values.get(0), (Layer)this, Expression.class);
            } else if (name.equalsIgnoreCase("isLeaf")) {
                this.isLeaf = FunctionLoader.load(values.get(0), (Layer)this, Expression.class);
            } else if (name.equalsIgnoreCase("isRoot")) {
                this.isRoot = FunctionLoader.load(values.get(0), (Layer)this, Expression.class);
            } else if (name.equalsIgnoreCase("leafs")) {
                this.leafs = FunctionLoader.load(values.get(0), (Layer)this, Expression.class);
            }
        }

        public Create create() {
            return new Create(null);
        }

        public Create create(String name) {
            return new Create(name);
        }

        public Clear clear() {
            return new Clear();
        }

        public NessGraph graph() {
            return this.core$().graph().as(NessGraph.class);
        }

        public class Clear {
            public void split(Predicate<Split> filter) {
                new ArrayList<Split>(Split.this.splitList()).stream().filter(filter).forEach(Layer::delete$);
            }
        }

        public class Create {
            protected final String name;

            public Create(String name) {
                this.name = name;
            }

            public Split split() {
                Split newElement = Split.this.core$().graph().concept(Split.class).createNode(this.name, Split.this.core$()).as(Split.class);
                return newElement;
            }
        }
    }

    public static class ProcessStatus
    extends Layer
    implements Terminal {
        protected String name;
        protected Split split;

        public ProcessStatus(Node node) {
            super(node);
        }

        public String name() {
            return this.name;
        }

        public Split split() {
            return this.split;
        }

        public ProcessStatus split(Split value) {
            this.split = value;
            return this;
        }

        @Override
        protected Map<String, List<?>> variables$() {
            LinkedHashMap map = new LinkedHashMap();
            map.put("name", new ArrayList<String>(Collections.singletonList(this.name)));
            map.put("split", this.split != null ? new ArrayList<Split>(Collections.singletonList(this.split)) : Collections.emptyList());
            return map;
        }

        @Override
        protected void load$(String name, List<?> values) {
            super.load$(name, values);
            if (name.equalsIgnoreCase("name")) {
                this.name = StringLoader.load(values, this).get(0);
            } else if (name.equalsIgnoreCase("split")) {
                this.split = NodeLoader.load(values, Split.class, this).get(0);
            }
        }

        @Override
        protected void set$(String name, List<?> values) {
            super.set$(name, values);
            if (name.equalsIgnoreCase("name")) {
                this.name = (String)values.get(0);
            } else if (name.equalsIgnoreCase("split")) {
                this.split = values.get(0) != null ? this.core$().graph().load(((Layer)values.get(0)).core$().id()).as(Split.class) : null;
            }
        }

        public NessGraph graph() {
            return this.core$().graph().as(NessGraph.class);
        }
    }

    public static class Seal
    extends Layer
    implements Terminal {
        protected Cron cron;

        public Seal(Node node) {
            super(node);
        }

        public Cron cron() {
            return this.cron;
        }

        @Override
        protected List<Node> componentList$() {
            LinkedHashSet<Node> components = new LinkedHashSet<Node>(super.componentList$());
            if (this.cron != null) {
                components.add(this.cron.core$());
            }
            return new ArrayList<Node>(components);
        }

        @Override
        protected Map<String, List<?>> variables$() {
            LinkedHashMap map = new LinkedHashMap();
            return map;
        }

        @Override
        protected void addNode$(Node node) {
            super.addNode$(node);
            if (node.is("Datalake$Seal$Cron")) {
                this.cron = node.as(Cron.class);
            }
        }

        @Override
        protected void removeNode$(Node node) {
            super.removeNode$(node);
            if (node.is("Datalake$Seal$Cron")) {
                this.cron = null;
            }
        }

        @Override
        protected void load$(String name, List<?> values) {
            super.load$(name, values);
        }

        @Override
        protected void set$(String name, List<?> values) {
            super.set$(name, values);
        }

        public Create create() {
            return new Create(null);
        }

        public Create create(String name) {
            return new Create(name);
        }

        public NessGraph graph() {
            return this.core$().graph().as(NessGraph.class);
        }

        public static class Cron
        extends Layer
        implements Terminal {
            protected String pattern;
            protected String timeZone;

            public Cron(Node node) {
                super(node);
            }

            public String pattern() {
                return this.pattern;
            }

            public String timeZone() {
                return this.timeZone;
            }

            public Cron pattern(String value) {
                this.pattern = value;
                return this;
            }

            public Cron timeZone(String value) {
                this.timeZone = value;
                return this;
            }

            @Override
            protected Map<String, List<?>> variables$() {
                LinkedHashMap map = new LinkedHashMap();
                map.put("pattern", new ArrayList<String>(Collections.singletonList(this.pattern)));
                map.put("timeZone", new ArrayList<String>(Collections.singletonList(this.timeZone)));
                return map;
            }

            @Override
            protected void load$(String name, List<?> values) {
                super.load$(name, values);
                if (name.equalsIgnoreCase("pattern")) {
                    this.pattern = StringLoader.load(values, this).get(0);
                } else if (name.equalsIgnoreCase("timeZone")) {
                    this.timeZone = StringLoader.load(values, this).get(0);
                }
            }

            @Override
            protected void set$(String name, List<?> values) {
                super.set$(name, values);
                if (name.equalsIgnoreCase("pattern")) {
                    this.pattern = (String)values.get(0);
                } else if (name.equalsIgnoreCase("timeZone")) {
                    this.timeZone = (String)values.get(0);
                }
            }

            public NessGraph graph() {
                return this.core$().graph().as(NessGraph.class);
            }
        }

        public class Create {
            protected final String name;

            public Create(String name) {
                this.name = name;
            }

            public Cron cron(String pattern, String timeZone) {
                Cron newElement = Seal.this.core$().graph().concept(Cron.class).createNode(this.name, Seal.this.core$()).as(Cron.class);
                newElement.core$().set(newElement, "pattern", Collections.singletonList(pattern));
                newElement.core$().set(newElement, "timeZone", Collections.singletonList(timeZone));
                return newElement;
            }
        }
    }

    public static class Backup
    extends Layer
    implements Terminal {
        protected String path;
        protected Cron cron;

        public Backup(Node node) {
            super(node);
        }

        public String path() {
            return this.path;
        }

        public Backup path(String value) {
            this.path = value;
            return this;
        }

        public Cron cron() {
            return this.cron;
        }

        @Override
        protected List<Node> componentList$() {
            LinkedHashSet<Node> components = new LinkedHashSet<Node>(super.componentList$());
            if (this.cron != null) {
                components.add(this.cron.core$());
            }
            return new ArrayList<Node>(components);
        }

        @Override
        protected Map<String, List<?>> variables$() {
            LinkedHashMap map = new LinkedHashMap();
            map.put("path", new ArrayList<String>(Collections.singletonList(this.path)));
            return map;
        }

        @Override
        protected void addNode$(Node node) {
            super.addNode$(node);
            if (node.is("Datalake$Backup$Cron")) {
                this.cron = node.as(Cron.class);
            }
        }

        @Override
        protected void removeNode$(Node node) {
            super.removeNode$(node);
            if (node.is("Datalake$Backup$Cron")) {
                this.cron = null;
            }
        }

        @Override
        protected void load$(String name, List<?> values) {
            super.load$(name, values);
            if (name.equalsIgnoreCase("path")) {
                this.path = StringLoader.load(values, this).get(0);
            }
        }

        @Override
        protected void set$(String name, List<?> values) {
            super.set$(name, values);
            if (name.equalsIgnoreCase("path")) {
                this.path = (String)values.get(0);
            }
        }

        public Create create() {
            return new Create(null);
        }

        public Create create(String name) {
            return new Create(name);
        }

        public NessGraph graph() {
            return this.core$().graph().as(NessGraph.class);
        }

        public static class Cron
        extends Layer
        implements Terminal {
            protected String pattern;
            protected String timeZone;

            public Cron(Node node) {
                super(node);
            }

            public String pattern() {
                return this.pattern;
            }

            public String timeZone() {
                return this.timeZone;
            }

            public Cron pattern(String value) {
                this.pattern = value;
                return this;
            }

            public Cron timeZone(String value) {
                this.timeZone = value;
                return this;
            }

            @Override
            protected Map<String, List<?>> variables$() {
                LinkedHashMap map = new LinkedHashMap();
                map.put("pattern", new ArrayList<String>(Collections.singletonList(this.pattern)));
                map.put("timeZone", new ArrayList<String>(Collections.singletonList(this.timeZone)));
                return map;
            }

            @Override
            protected void load$(String name, List<?> values) {
                super.load$(name, values);
                if (name.equalsIgnoreCase("pattern")) {
                    this.pattern = StringLoader.load(values, this).get(0);
                } else if (name.equalsIgnoreCase("timeZone")) {
                    this.timeZone = StringLoader.load(values, this).get(0);
                }
            }

            @Override
            protected void set$(String name, List<?> values) {
                super.set$(name, values);
                if (name.equalsIgnoreCase("pattern")) {
                    this.pattern = (String)values.get(0);
                } else if (name.equalsIgnoreCase("timeZone")) {
                    this.timeZone = (String)values.get(0);
                }
            }

            public NessGraph graph() {
                return this.core$().graph().as(NessGraph.class);
            }
        }

        public class Create {
            protected final String name;

            public Create(String name) {
                this.name = name;
            }

            public Cron cron(String pattern, String timeZone) {
                Cron newElement = Backup.this.core$().graph().concept(Cron.class).createNode(this.name, Backup.this.core$()).as(Cron.class);
                newElement.core$().set(newElement, "pattern", Collections.singletonList(pattern));
                newElement.core$().set(newElement, "timeZone", Collections.singletonList(timeZone));
                return newElement;
            }
        }
    }

    public class Clear {
        public void split(Predicate<Split> filter) {
            new ArrayList<Split>(Datalake.this.splitList()).stream().filter(filter).forEach(Layer::delete$);
        }

        public void tank(Predicate<Tank> filter) {
            new ArrayList<Tank>(Datalake.this.tankList()).stream().filter(filter).forEach(Layer::delete$);
        }
    }

    public class Create {
        protected final String name;

        public Create(String name) {
            this.name = name;
        }

        public Backup backup() {
            Backup newElement = Datalake.this.core$().graph().concept(Backup.class).createNode(this.name, Datalake.this.core$()).as(Backup.class);
            return newElement;
        }

        public Seal seal() {
            Seal newElement = Datalake.this.core$().graph().concept(Seal.class).createNode(this.name, Datalake.this.core$()).as(Seal.class);
            return newElement;
        }

        public ProcessStatus processStatus(Split split) {
            ProcessStatus newElement = Datalake.this.core$().graph().concept(ProcessStatus.class).createNode(this.name, Datalake.this.core$()).as(ProcessStatus.class);
            newElement.core$().set(newElement, "split", Collections.singletonList(split));
            return newElement;
        }

        public Split split() {
            Split newElement = Datalake.this.core$().graph().concept(Split.class).createNode(this.name, Datalake.this.core$()).as(Split.class);
            return newElement;
        }

        public Tank tank() {
            Tank newElement = Datalake.this.core$().graph().concept(Tank.class).createNode(this.name, Datalake.this.core$()).as(Tank.class);
            return newElement;
        }
    }
}

