/*
 * Decompiled with CFR 0.152.
 */
package io.intino.datahub.datalake.regenerator;

import io.intino.alexandria.Fingerprint;
import io.intino.alexandria.Timetag;
import io.intino.alexandria.datalake.Datalake;
import io.intino.alexandria.event.Event;
import io.intino.alexandria.event.EventReader;
import io.intino.alexandria.logger.Logger;
import io.intino.alexandria.message.MessageWriter;
import io.intino.datahub.datalake.regenerator.Mapper;
import io.intino.datahub.datalake.regenerator.RegeneratorReporter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.time.Instant;
import java.util.Collection;
import org.apache.commons.io.FileUtils;
import org.xerial.snappy.SnappyOutputStream;

public class SessionRegenerator {
    private final Datalake datalake;
    private final File backupDirectory;
    private final File reviewDirectory;
    private final String ts;

    public SessionRegenerator(Datalake datalake, File backupDirectory, File reviewDirectory, String ts) {
        this.datalake = datalake;
        this.backupDirectory = backupDirectory;
        this.reviewDirectory = reviewDirectory;
        this.ts = this.ts();
    }

    public File review(Mapper mapper) {
        File reportFile = new File(this.reviewDirectory, this.mapperPrefixName(mapper) + ".html");
        RegeneratorReporter reporter = new RegeneratorReporter(reportFile);
        for (File session : this.sessions()) {
            if (!this.suitable(session, mapper.filter())) continue;
            new EventReader(session).forEachRemaining(e -> {
                String before = e.toString();
                this.map(mapper, reporter, session, (Event)e, before);
            });
        }
        reporter.commit();
        return reportFile;
    }

    public File revise(Mapper mapper) {
        File reportFile = new File(this.backupDirectory, this.mapperPrefixName(mapper) + ".html");
        RegeneratorReporter reporter = new RegeneratorReporter(reportFile);
        for (File session : this.sessions()) {
            if (!this.suitable(session, mapper.filter())) continue;
            MessageWriter writer = new MessageWriter(this.zipStream(this.temp(session)));
            new EventReader(session).forEachRemaining(e -> {
                String before = e.toString();
                Event after = this.map(mapper, reporter, session, (Event)e, before);
                if (after != null) {
                    this.write(writer, after);
                }
            });
            this.close(writer);
            this.backupSourceSession(mapper, session);
            if (this.temp(session).length() > 20L) {
                this.move(this.temp(session), session);
                continue;
            }
            this.temp(session).delete();
        }
        reporter.commit();
        return reportFile;
    }

    private boolean suitable(File session, Mapper.Filter filter) {
        Datalake.EventStore.Tank tank = this.tankOf(session);
        return filter.allow(tank) && filter.allow(tank, this.timetagOf(session));
    }

    private Event map(Mapper mapper, RegeneratorReporter reporter, File session, Event e, String before) {
        Event after = e;
        Mapper.Filter filter = mapper.filter();
        if (filter.allow(e)) {
            after = mapper.apply(e);
            reporter.addItem(before, after == null ? null : after.toString());
        }
        return after;
    }

    private Timetag timetagOf(File session) {
        return SessionRegenerator.fingerprintOf(session).timetag();
    }

    private Datalake.EventStore.Tank tankOf(File session) {
        return this.datalake.eventStore().tank(SessionRegenerator.fingerprintOf(session).tank());
    }

    private Collection<File> sessions() {
        this.backupDirectory.mkdirs();
        return FileUtils.listFiles(this.backupDirectory, new String[]{"event.session.treated"}, true);
    }

    private void backupSourceSession(Mapper mapper, File session) {
        File dest = new File(session.getParentFile(), this.mapperPrefixName(mapper) + "_" + session.getName() + ".bak");
        this.move(session, dest);
    }

    private String mapperPrefixName(Mapper mapper) {
        return "backup_" + mapper.getClass().getSimpleName() + "_" + this.ts;
    }

    private File temp(File file) {
        return new File(file.getAbsolutePath() + ".tmp");
    }

    private String ts() {
        return Instant.now().toString().replaceAll("-|:", "").replace("T", "").substring(0, 14);
    }

    private void move(File source, File dest) {
        try {
            Files.move(source.toPath(), dest.toPath(), new CopyOption[0]);
        }
        catch (IOException e) {
            Logger.error(e);
        }
    }

    private void write(MessageWriter writer, Event after) {
        try {
            writer.write(after.toMessage());
        }
        catch (IOException e) {
            Logger.error(e);
        }
    }

    private void close(MessageWriter writer) {
        try {
            writer.close();
        }
        catch (IOException e) {
            Logger.error(e);
        }
    }

    private SnappyOutputStream zipStream(File file) {
        try {
            return new SnappyOutputStream(new FileOutputStream(file));
        }
        catch (IOException e) {
            Logger.error(e);
            return null;
        }
    }

    private static Fingerprint fingerprintOf(File file) {
        return new Fingerprint(SessionRegenerator.cleanedNameOf(file));
    }

    private static String cleanedNameOf(File file) {
        return file.getName().substring(0, file.getName().indexOf("#")).replace("-", "/").replace(".event.session.treated", "");
    }
}

