/*
 * Decompiled with CFR 0.152.
 */
package io.intino.datahub.datalake.regenerator;

import io.intino.alexandria.Timetag;
import io.intino.alexandria.datalake.Datalake;
import io.intino.alexandria.datalake.file.FileDatalake;
import io.intino.alexandria.datalake.file.FileEventTub;
import io.intino.alexandria.datalake.file.eventsourcing.EventPump;
import io.intino.alexandria.datalake.file.eventsourcing.FileEventPump;
import io.intino.alexandria.event.Event;
import io.intino.alexandria.logger.Logger;
import io.intino.alexandria.message.MessageWriter;
import io.intino.datahub.datalake.regenerator.Mapper;
import io.intino.datahub.datalake.regenerator.RegeneratorReporter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.util.Comparator;
import org.xerial.snappy.SnappyOutputStream;

public class DatalakeRegenerator {
    protected final FileDatalake datalake;
    private final File reviewsDirectory;
    private final String ts;

    public DatalakeRegenerator(FileDatalake datalake, File reviewsDirectory, String ts) {
        this.datalake = datalake;
        this.reviewsDirectory = reviewsDirectory;
        this.ts = ts;
    }

    public File review(Mapper mapper) {
        File reportFile = new File(this.reviewsDirectory, this.mapperPrefixName(mapper) + ".html");
        RegeneratorReporter reporter = new RegeneratorReporter(reportFile);
        EventPump.Reflow reflow = new FileEventPump(this.datalake.eventStore()).reflow(mapper.filter());
        while (reflow.hasNext()) {
            reflow.next(1, event -> this.review(mapper, reporter, event));
        }
        reporter.commit();
        return reportFile;
    }

    public File revise(Mapper mapper) {
        File reportFile = new File(this.datalake.root(), this.mapperPrefixName(mapper) + ".html");
        RegeneratorReporter reporter = new RegeneratorReporter(reportFile);
        this.datalake.eventStore().tanks().sorted(Comparator.comparing(Datalake.EventStore.Tank::name)).filter(tank -> mapper.filter().allow((Datalake.EventStore.Tank)tank)).forEach(tank -> this.timetags((Datalake.EventStore.Tank)tank).forEach(timetag -> {
            if (mapper.filter().allow((Datalake.EventStore.Tank)tank, (Timetag)timetag)) {
                FileEventTub tub = (FileEventTub)tank.on((Timetag)timetag);
                if (!tub.file().exists()) {
                    return;
                }
                MessageWriter writer = new MessageWriter(this.zipStream(this.temp(tub)));
                tub.events().forEachRemaining(e -> {
                    String before = e.toMessage().toString();
                    Event after = e;
                    if (mapper.filter().allow((Event)e)) {
                        after = mapper.apply((Event)e);
                        reporter.addItem(before, after == null ? null : after.toString());
                    }
                    if (after != null) {
                        this.write(writer, after);
                    }
                });
                this.close(writer);
                this.backupSourceTub(mapper, tub);
                if (this.temp(tub).length() > 20L) {
                    this.move(this.temp(tub), tub.file());
                } else {
                    this.temp(tub).delete();
                }
            }
        }));
        reporter.commit();
        return reportFile;
    }

    private void close(MessageWriter writer) {
        try {
            writer.close();
        }
        catch (IOException e) {
            Logger.error(e);
        }
    }

    private void write(MessageWriter writer, Event after) {
        try {
            writer.write(after.toMessage());
        }
        catch (IOException e) {
            Logger.error(e);
        }
    }

    private void review(Mapper mapper, RegeneratorReporter reporter, Event event) {
        if (mapper.filter().allow(event)) {
            String before = event.toMessage().toString();
            Event after = mapper.apply(event);
            reporter.addItem(before, after == null ? null : after.toString());
        }
    }

    private File temp(FileEventTub tub) {
        return new File(tub.file().getAbsolutePath() + ".tmp");
    }

    private void backupSourceTub(Mapper mapper, FileEventTub tub) {
        File source = tub.file();
        File dest = new File(source.getParentFile(), this.mapperPrefixName(mapper) + "_" + source.getName() + ".bak");
        this.move(source, dest);
    }

    private String mapperPrefixName(Mapper mapper) {
        return "datalake_" + mapper.getClass().getSimpleName() + "_" + this.ts;
    }

    private Iterable<Timetag> timetags(Datalake.EventStore.Tank tank) {
        return tank.first().timetag().iterateTo(tank.last().timetag());
    }

    private void move(File source, File dest) {
        try {
            Files.move(source.toPath(), dest.toPath(), new CopyOption[0]);
        }
        catch (IOException e) {
            Logger.error(e);
        }
    }

    private SnappyOutputStream zipStream(File file) {
        try {
            return new SnappyOutputStream(new FileOutputStream(file));
        }
        catch (IOException e) {
            Logger.error(e);
            return null;
        }
    }
}

