/*
 * Decompiled with CFR 0.152.
 */
package io.intino.datahub.box.service.scheduling;

import io.intino.alexandria.logger.Logger;
import io.intino.alexandria.scheduler.AlexandriaScheduler;
import io.intino.alexandria.scheduler.ScheduledTrigger;
import io.intino.datahub.box.DataHubBox;
import io.intino.datahub.box.actions.BackupAction;
import io.intino.datahub.box.actions.SealAction;
import io.intino.datahub.graph.Datalake;
import io.intino.magritte.framework.Layer;
import java.time.ZoneId;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.TimeZone;
import org.quartz.CronScheduleBuilder;
import org.quartz.JobBuilder;
import org.quartz.JobDetail;
import org.quartz.JobExecutionContext;
import org.quartz.SchedulerException;
import org.quartz.Trigger;
import org.quartz.TriggerBuilder;

public class Sentinels {
    private final AlexandriaScheduler scheduler = new AlexandriaScheduler();

    public Sentinels(DataHubBox box) {
        try {
            String zoneId;
            Layer cron;
            JobDetail job;
            if (box.graph().datalake() != null && box.graph().datalake().seal() != null) {
                job = JobBuilder.newJob(SealingListener.class).withIdentity("Sealing").build();
                job.getJobDataMap().put("box", (Object)box);
                cron = box.graph().datalake().seal().cron();
                zoneId = ((Datalake.Seal.Cron)cron).timeZone();
                this.scheduler.scheduleJob(job, Sentinels.newSet(TriggerBuilder.newTrigger().withIdentity("DataHub#Sealing").withSchedule(CronScheduleBuilder.cronSchedule(((Datalake.Seal.Cron)cron).pattern()).inTimeZone(zoneId == null ? TimeZone.getDefault() : TimeZone.getTimeZone(ZoneId.of(zoneId)))).build(), TriggerBuilder.newTrigger().startNow().build()), true);
            }
            if (box.graph().datalake() != null && box.graph().datalake().backup() != null) {
                job = JobBuilder.newJob(DatalakeBackupListener.class).withIdentity("DatalakeBackup").build();
                job.getJobDataMap().put("box", (Object)box);
                cron = box.graph().datalake().backup().cron();
                zoneId = ((Datalake.Backup.Cron)cron).timeZone();
                this.scheduler.scheduleJob(job, Sentinels.newSet(TriggerBuilder.newTrigger().withIdentity("DataHub#DatalakeBackup").withSchedule(CronScheduleBuilder.cronSchedule(((Datalake.Backup.Cron)cron).pattern()).inTimeZone(zoneId == null ? TimeZone.getDefault() : TimeZone.getTimeZone(ZoneId.of(zoneId)))).build()), true);
            }
            this.scheduler.startSchedules();
        }
        catch (Exception e) {
            Logger.error(e.getMessage());
        }
    }

    public void stop() {
        try {
            this.scheduler.shutdownSchedules();
        }
        catch (SchedulerException e) {
            Logger.error(e);
        }
    }

    private static Set<Trigger> newSet(Trigger ... triggers) {
        LinkedHashSet<Trigger> set = new LinkedHashSet<Trigger>();
        Collections.addAll(set, triggers);
        return set;
    }

    public static class SealingListener
    implements ScheduledTrigger {
        @Override
        public void execute(JobExecutionContext context) {
            new SealAction((DataHubBox)context.getMergedJobDataMap().get("box")).execute();
        }
    }

    public static class DatalakeBackupListener
    implements ScheduledTrigger {
        @Override
        public void execute(JobExecutionContext context) {
            new BackupAction((DataHubBox)context.getMergedJobDataMap().get("box")).execute();
        }
    }
}

