/*
 * Decompiled with CFR 0.152.
 */
package io.intino.datahub.box.actions;

import io.intino.alexandria.logger.Logger;
import io.intino.datahub.box.DataHubBox;
import java.io.File;
import java.io.IOException;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.io.FileUtils;

public class SealAction {
    private static final AtomicBoolean started = new AtomicBoolean(false);
    private static final Object monitor = new Object();
    public DataHubBox box;

    public SealAction() {
    }

    public SealAction(DataHubBox box) {
        this.box = box;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String execute() {
        Object object = monitor;
        synchronized (object) {
            if (started.get()) {
                return "Sealing already started";
            }
            try {
                started.set(true);
                this.box.brokerSessions().push();
                this.cleanStage();
                this.box.sessionSealer().seal();
                if (this.box.graph().datalake().backup() == null) {
                    this.cleanTreated();
                }
                Logger.info("Finished sealing!");
                started.set(false);
            }
            catch (Throwable e) {
                Logger.error(e);
            }
            return "Finished sealing!";
        }
    }

    public synchronized void execute(String stage) {
        if (started.get()) {
            return;
        }
        started.set(true);
        File subStage = new File(this.box.stageDirectory(), stage);
        if (subStage.exists()) {
            this.box.sessionSealer(subStage).seal();
        }
        Logger.info("Finished sealing of stage " + stage);
        started.set(false);
    }

    private void cleanStage() {
        for (File file : Objects.requireNonNull(this.box.stageDirectory().listFiles())) {
            if (!file.isDirectory() || Objects.requireNonNull(file.listFiles()).length != 0) continue;
            try {
                FileUtils.deleteDirectory(file);
            }
            catch (IOException e) {
                Logger.error(e);
            }
        }
    }

    private void cleanTreated() {
        Instant lastWeek = Instant.now().minus(7L, ChronoUnit.DAYS);
        FileUtils.listFiles(this.box.stageDirectory(), new String[]{"treated"}, true).forEach(f -> {
            if (Instant.ofEpochMilli(f.lastModified()).isBefore(lastWeek)) {
                f.delete();
            }
        });
    }
}

