/*
 * Decompiled with CFR 0.152.
 */
package io.intino.datahub.box.actions;

import io.intino.alexandria.Context;
import io.intino.alexandria.logger.Logger;
import io.intino.datahub.box.DataHubBox;
import io.intino.datahub.datalake.regenerator.Mapper;
import io.intino.datahub.datalake.regenerator.MapperLoader;
import io.intino.datahub.datalake.regenerator.MapperReader;
import io.intino.datahub.datalake.regenerator.Regenerator;
import io.intino.datahub.graph.Datalake;
import java.io.File;
import java.nio.file.Files;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;

public class ReviseAction {
    public DataHubBox box;
    public Context context = new Context();
    public String mapper;
    private static final AtomicBoolean started = new AtomicBoolean(false);

    public String execute() {
        if (started.get()) {
            return "Already started an action";
        }
        started.set(true);
        try {
            String mapperCode = new MapperReader(this.box.mappersDirectory()).read(this.mapper);
            if (mapperCode == null) {
                started.set(false);
                return "Mapper not found";
            }
            Mapper mapper = new MapperLoader(this.box.configuration().home()).compileAndLoad(mapperCode);
            if (mapper == null) {
                started.set(false);
                return "Mapper " + this.mapper + " cannot be loaded";
            }
            Datalake.Backup backup = this.box.graph().datalake().backup();
            File sessionsDirectory = backup == null ? null : new File(backup.path(), "sessions");
            File reviewsDirectory = new File(this.box.configuration().home(), "reviews");
            reviewsDirectory.mkdirs();
            List<File> revise = new Regenerator(this.box.datalake(), sessionsDirectory, reviewsDirectory).revise(mapper);
            started.set(false);
            return Files.readString(revise.get(0).toPath());
        }
        catch (Exception e) {
            Logger.error(e);
            started.set(false);
            return "Impossible to create review: " + e.getMessage();
        }
    }
}

