/*
 * Decompiled with CFR 0.152.
 */
package io.intino.datahub.box;

import io.intino.alexandria.core.Box;
import io.intino.alexandria.datalake.file.FileDatalake;
import io.intino.alexandria.logger.Logger;
import io.intino.alexandria.sealing.FileSessionSealer;
import io.intino.alexandria.sealing.SessionSealer;
import io.intino.alexandria.ui.services.AuthService;
import io.intino.datahub.box.AbstractBox;
import io.intino.datahub.box.DataHubConfiguration;
import io.intino.datahub.box.service.jms.NessService;
import io.intino.datahub.box.service.scheduling.Sentinels;
import io.intino.datahub.broker.BrokerService;
import io.intino.datahub.broker.jms.JmsBrokerService;
import io.intino.datahub.datalake.BrokerSessions;
import io.intino.datahub.graph.NessGraph;
import io.intino.magritte.framework.Graph;
import java.io.File;
import java.net.URL;

public class DataHubBox
extends AbstractBox {
    private FileDatalake datalake;
    private BrokerService brokerService;
    private BrokerSessions brokerSessions;
    private NessService nessService;
    private Sentinels sentinels;
    private NessGraph graph;

    public DataHubBox(String[] args) {
        super(args);
    }

    public DataHubBox(DataHubConfiguration configuration) {
        super(configuration);
    }

    @Override
    public Box put(Object o) {
        super.put(o);
        if (o instanceof Graph) {
            this.graph = ((Graph)o).as(NessGraph.class);
            this.injectJmsConfiguration();
        }
        if (o instanceof NessGraph) {
            this.graph = (NessGraph)o;
            this.injectJmsConfiguration();
        }
        return this;
    }

    public BrokerService brokerService() {
        return this.brokerService;
    }

    public NessGraph graph() {
        return this.graph;
    }

    public BrokerSessions brokerSessions() {
        return this.brokerSessions;
    }

    public SessionSealer sessionSealer() {
        return new FileSessionSealer(this.datalake, this.stageDirectory());
    }

    private void injectJmsConfiguration() {
        if (this.graph.datalake() != null) {
            this.graph.datalake().path(this.datalakeDirectory().getAbsolutePath());
            if (this.graph.datalake().backup() != null) {
                this.graph.datalake().backup().path(this.configuration.backupDirectory());
            }
        }
        if (this.graph.broker() != null) {
            this.graph.broker().path(this.brokerDirectory().getAbsolutePath());
            this.graph.broker().port(Integer.parseInt(this.configuration.brokerPort()));
            this.graph.broker().secondaryPort(Integer.parseInt(this.configuration.brokerSecondaryPort()));
        }
    }

    private File brokerDirectory() {
        return new File(this.configuration.home(), "datahub/broker");
    }

    public File stageDirectory() {
        return new File(this.configuration.home(), "datahub/stage");
    }

    public File mappersDirectory() {
        File mappers = new File(this.configuration.home(), "datahub/mappers");
        mappers.mkdirs();
        return mappers;
    }

    public SessionSealer sessionSealer(File stageDirectory) {
        return new FileSessionSealer(this.datalake, stageDirectory);
    }

    @Override
    public void beforeStart() {
        this.stageDirectory().mkdirs();
        this.load();
        if (this.graph.datalake() != null) {
            this.datalake = new FileDatalake(this.datalakeDirectory());
        }
        if (this.graph.broker() != null) {
            this.configureBroker();
            this.nessService = new NessService(this);
        }
        this.sentinels = new Sentinels(this);
    }

    private File datalakeDirectory() {
        return new File(this.configuration.home(), "datalake");
    }

    @Override
    public void afterStart() {
    }

    @Override
    public void beforeStop() {
    }

    @Override
    public void afterStop() {
    }

    @Override
    protected AuthService authService(URL authServiceUrl) {
        return null;
    }

    private void load() {
        if (this.graph.broker() != null && this.graph.broker().implementation() == null) {
            this.graph.broker().implementation(() -> new JmsBrokerService(this.graph, this.brokerStage()));
        }
    }

    private void configureBroker() {
        this.brokerService = this.graph.broker().implementation().get();
        this.brokerSessions = new BrokerSessions(this.brokerStage(), this.stageDirectory());
        try {
            this.brokerService.start();
        }
        catch (Exception e) {
            Logger.error(e);
        }
    }

    private File brokerStage() {
        return new File(this.brokerDirectory(), "stage");
    }

    public FileDatalake datalake() {
        return this.datalake;
    }
}

