/*
 * Decompiled with CFR 0.152.
 */
package io.intino.datahub.box;

import io.intino.alexandria.core.Box;
import io.intino.alexandria.http.AlexandriaSparkBuilder;
import io.intino.alexandria.jmx.JMXServer;
import io.intino.alexandria.logger.Formatter;
import io.intino.alexandria.ui.AlexandriaUiBox;
import io.intino.alexandria.ui.Soul;
import io.intino.alexandria.ui.UISpark;
import io.intino.alexandria.ui.UiElementsService;
import io.intino.alexandria.ui.services.AuthService;
import io.intino.alexandria.ui.services.TranslatorService;
import io.intino.alexandria.ui.services.push.PushService;
import io.intino.datahub.box.DataHubBox;
import io.intino.datahub.box.DataHubConfiguration;
import io.intino.datahub.box.I18n;
import io.intino.datahub.box.JMXService;
import io.intino.datahub.box.ui.DatalakeInspectorService;
import io.intino.datahub.box.ui.displays.RouteDispatcher;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.logging.ConsoleHandler;
import java.util.logging.Level;
import java.util.logging.Logger;

public abstract class AbstractBox
extends AlexandriaUiBox {
    protected DataHubConfiguration configuration;
    protected JMXServer service;
    protected Map<String, Soul> uiSouls = new HashMap<String, Soul>();
    private List<AlexandriaUiBox.SoulsClosed> soulsClosedListeners = new ArrayList<AlexandriaUiBox.SoulsClosed>();
    private AuthService authService;
    private PushService pushService;

    public AbstractBox(String[] args) {
        this(new DataHubConfiguration(args));
    }

    public AbstractBox(DataHubConfiguration configuration) {
        this.configuration = configuration;
        this.initJavaLogger();
    }

    @Override
    public DataHubConfiguration configuration() {
        return this.configuration;
    }

    @Override
    public Box put(Object o) {
        return this;
    }

    @Override
    public abstract void beforeStart();

    @Override
    public Box start() {
        if (this.owner != null) {
            this.owner.beforeStart();
        }
        this.beforeStart();
        if (this.owner != null) {
            this.owner.startServices();
        }
        this.startServices();
        if (this.owner != null) {
            this.owner.afterStart();
        }
        this.afterStart();
        return this;
    }

    @Override
    public abstract void afterStart();

    @Override
    public abstract void beforeStop();

    @Override
    public void stop() {
        if (this.owner != null) {
            this.owner.beforeStop();
        }
        this.beforeStop();
        if (this.owner != null) {
            this.owner.stopServices();
        }
        this.stopServices();
        if (this.owner != null) {
            this.owner.afterStop();
        }
        this.afterStop();
    }

    @Override
    public void stopServices() {
        AlexandriaSparkBuilder.instance().stop();
    }

    @Override
    public abstract void afterStop();

    @Override
    public void startServices() {
        this.initUI();
        this.initConnector();
        this.initRestServices();
        this.initSoapServices();
        this.initJmxServices();
        this.initDatalake();
        this.initTerminal();
        this.initMessagingServices();
        this.initSentinels();
        this.initSlackBots();
        this.initWorkflow();
    }

    public PushService pushService() {
        return this.pushService;
    }

    public List<Soul> souls() {
        return new ArrayList<Soul>(this.uiSouls.values());
    }

    public Optional<Soul> soul(String clientId) {
        return Optional.ofNullable(this.uiSouls.get(clientId));
    }

    @Override
    public void registerSoul(String clientId, Soul soul) {
        this.uiSouls.put(clientId, soul);
    }

    @Override
    public void unRegisterSoul(String clientId) {
        this.uiSouls.remove(clientId);
        if (this.uiSouls.size() <= 0) {
            this.notifySoulsClosed();
        }
    }

    public void onSoulsClosed(AlexandriaUiBox.SoulsClosed listener) {
        this.soulsClosedListeners.add(listener);
    }

    private void notifySoulsClosed() {
        this.soulsClosedListeners.forEach(l -> l.accept());
    }

    protected abstract AuthService authService(URL var1);

    public void setupUi() {
        if (this.configuration().get("ui_port") == null || this.configuration().get("ui_port").isEmpty()) {
            return;
        }
        this.authService = null;
        AlexandriaSparkBuilder.setup(Integer.parseInt(this.configuration().get("ui_port")), "www/");
        AlexandriaSparkBuilder.setUI(true);
        AlexandriaSparkBuilder.addParameters(this.authService);
        this.pushService = new PushService();
        UISpark sparkInstance = (UISpark)AlexandriaSparkBuilder.instance();
        DatalakeInspectorService.init(sparkInstance, (DataHubBox)this, this.pushService, new RouteDispatcher());
        UiElementsService.initDisplays(sparkInstance, this.pushService);
    }

    private void initRestServices() {
    }

    private void initSoapServices() {
    }

    private void initMessagingServices() {
    }

    private void initJmxServices() {
        this.service = new JMXService().init((DataHubBox)this);
        io.intino.alexandria.logger.Logger.info("Jmx service service: started!");
    }

    private void initSlackBots() {
    }

    private void initUI() {
        this.setupUi();
        this.initTranslatorService();
        UISpark sparkInstance = (UISpark)AlexandriaSparkBuilder.instance();
        sparkInstance.start();
        io.intino.alexandria.logger.Logger.info("UI datalakeInspector: started at port " + this.configuration().get("ui_port") + "!");
    }

    private void initTranslatorService() {
        this.translatorService = new TranslatorService();
        this.translatorService.addAll(I18n.dictionaries());
        this.translatorService.addAll(io.intino.alexandria.I18n.dictionaries());
    }

    private void initDatalake() {
    }

    private void initConnector() {
    }

    private void initTerminal() {
    }

    private void initSentinels() {
    }

    private void initWorkflow() {
    }

    private void initJavaLogger() {
        Logger Logger2 = Logger.getGlobal();
        ConsoleHandler handler = new ConsoleHandler();
        handler.setLevel(Level.INFO);
        handler.setFormatter(new Formatter());
        Logger2.setUseParentHandlers(false);
        Logger2.addHandler(handler);
    }

    protected URL url(String url) {
        try {
            return new URL(url);
        }
        catch (MalformedURLException e) {
            return null;
        }
    }
}

