/*
 * Decompiled with CFR 0.152.
 */
package io.intino.cesar.datahub;

import io.intino.alexandria.core.Box;
import io.intino.alexandria.logger.Logger;
import io.intino.datahub.box.DataHubBox;
import io.intino.datahub.box.DataHubConfiguration;
import io.intino.datahub.graph.NessGraph;
import io.intino.magritte.framework.Graph;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;

public class Main {
    private static String[] stashes = new String[]{"DataHub"};

    public static void main(String[] args) {
        DataHubConfiguration configuration = new DataHubConfiguration(args);
        NessGraph graph = new Graph().loadStashes(stashes).as(NessGraph.class);
        Main.loadUsers(new File(configuration.home(), "datahub"), graph);
        Box box = new DataHubBox(args).put(graph.core$()).start();
        Runtime.getRuntime().addShutdownHook(new Thread(box::stop));
    }

    private static void loadUsers(File workspace, NessGraph nessGraph) {
        try {
            String[] users;
            File file = new File(workspace, "users.bin");
            if (!file.exists()) {
                return;
            }
            nessGraph.broker().clear().user(u -> true);
            for (String user : users = new String(Files.readAllBytes(file.toPath())).split("\n")) {
                nessGraph.broker().create().user(user.split("::")[0], user.split("::")[1]);
            }
        }
        catch (IOException e) {
            Logger.error(e);
        }
    }
}

