/*
 * Decompiled with CFR 0.152.
 */
package io.intino.alexandria.zim;

import io.intino.alexandria.message.Message;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.stream.Stream;

public interface ZimStream {
    public Message current();

    public Message next();

    public boolean hasNext();

    default public void forEachRemaining(Consumer<Message> action) {
        Objects.requireNonNull(action);
        while (this.hasNext()) {
            action.accept(this.next());
        }
    }

    public static class Empty
    implements ZimStream {
        @Override
        public Message current() {
            return null;
        }

        @Override
        public Message next() {
            return null;
        }

        @Override
        public boolean hasNext() {
            return false;
        }
    }

    public static class Sequence
    implements ZimStream {
        private final Iterator<ZimStream> iterator;
        private Message currentMessage;
        private ZimStream current;

        Sequence(ZimStream ... inputs) {
            this.iterator = this.streamOf(inputs).iterator();
            this.current = this.iterator.next();
        }

        private Stream<ZimStream> streamOf(ZimStream[] inputs) {
            return Arrays.stream(this.isEmpty(inputs) ? inputs : this.emptyInput());
        }

        private boolean isEmpty(ZimStream[] inputs) {
            return inputs.length > 0;
        }

        private ZimStream[] emptyInput() {
            return new ZimStream[]{new Empty()};
        }

        @Override
        public Message current() {
            return this.currentMessage;
        }

        @Override
        public Message next() {
            this.currentMessage = this.current.next();
            return this.currentMessage;
        }

        @Override
        public boolean hasNext() {
            return this.current.hasNext() || this.restHasNext();
        }

        private boolean restHasNext() {
            while (this.iterator.hasNext()) {
                this.current = this.iterator.next();
                if (!this.current.hasNext()) continue;
                return true;
            }
            return false;
        }

        public static Sequence of(ZimStream ... inputs) {
            return new Sequence(inputs);
        }
    }
}

