/*
 * Decompiled with CFR 0.152.
 */
package io.intino.alexandria.ui.spark;

import io.intino.alexandria.http.spark.SparkManager;
import io.intino.alexandria.ui.services.AuthService;
import io.intino.alexandria.ui.services.push.PushService;
import io.intino.alexandria.ui.services.push.UIClient;
import io.intino.alexandria.ui.services.push.UISession;
import java.util.Locale;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import spark.Request;
import spark.Response;

public class UISparkManager
extends SparkManager<PushService> {
    private final AuthService authService;
    private final boolean hasUserHome;
    public static final String KonosUserHomePath = "/konos/user";

    public UISparkManager(Request request, Response response, PushService pushService, AuthService authService, boolean hasUserHome) {
        super(pushService, request, response);
        this.authService = authService;
        this.hasUserHome = hasUserHome;
    }

    public AuthService authService() {
        return this.authService;
    }

    public void linkToThread(UIClient client) {
        ((PushService)this.pushService).linkToThread(client);
    }

    public void unlinkFromThread() {
        ((PushService)this.pushService).unlinkFromThread();
    }

    public void unRegister(UIClient client) {
        ((PushService)this.pushService).unRegister(client);
    }

    public String userHomePath() {
        return this.hasUserHome ? KonosUserHomePath : "";
    }

    public String requestUrl() {
        String requestUri;
        Object result = this.baseUrl();
        if (!((String)result).endsWith("/")) {
            result = (String)result + "/";
        }
        return (String)result + ((requestUri = this.request.raw().getRequestURI()) != null && requestUri.startsWith("/") ? requestUri.substring(1) : requestUri);
    }

    @Override
    public UISession currentSession() {
        return (UISession)super.currentSession();
    }

    public UISession session(String id) {
        return (UISession)((PushService)this.pushService()).session(id);
    }

    public UIClient client(String id) {
        return (UIClient)((PushService)this.pushService).client(id);
    }

    public UIClient currentClient() {
        return (UIClient)((PushService)this.pushService).currentClient();
    }

    public String languageFromHeader() {
        String language = this.request.raw().getHeader("Accept-Language");
        return language != null ? this.languageOf(language.split(",")[0]) : null;
    }

    public String ipAddressFromHeader() {
        HttpServletRequest raw = this.request.raw();
        String ipAddress = raw.getHeader("Remote_Addr");
        if (ipAddress == null || ipAddress.isEmpty()) {
            ipAddress = raw.getHeader("HTTP_X_FORWARDED_FOR");
        }
        if (ipAddress != null && !ipAddress.isEmpty()) {
            return ipAddress;
        }
        return raw.getRemoteAddr();
    }

    public String languageFromUrl() {
        return this.languageOf(this.request.queryParams("language"));
    }

    private String languageOf(String language) {
        if (language == null) {
            return null;
        }
        return Locale.forLanguageTag(language).toString().replaceAll(".*_", "").toLowerCase();
    }

    public Map<String, String> cookies() {
        return this.request.cookies();
    }

    @Override
    public void redirect(String location) {
        this.currentSession().browser().add("callback", this.requestUrl());
        super.redirect(location);
    }
}

