/*
 * Decompiled with CFR 0.152.
 */
package io.intino.alexandria.ui.displays.components.dashboard;

import io.intino.alexandria.drivers.Driver;
import io.intino.alexandria.drivers.Program;
import io.intino.alexandria.logger.Logger;
import io.intino.alexandria.proxy.Network;
import io.intino.alexandria.proxy.Proxy;
import io.intino.alexandria.ui.AlexandriaUiBox;
import io.intino.alexandria.ui.displays.DisplayRouteManager;
import io.intino.alexandria.ui.services.push.UISession;
import io.intino.alexandria.ui.spark.UISparkManager;
import java.io.PrintWriter;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import spark.Request;

public class DashboardManager {
    private final AlexandriaUiBox box;
    private final UISession session;
    private final String dashboard;
    private final Driver<URL, Proxy> driver;
    private static boolean routeManagerReady = false;
    private static final String DashboardsPathPattern = "/dashboards/:name/*";
    private static final String DashboardPathPattern = "/dashboards/:name";
    private static final String DashboardPath = "/dashboards/%s";
    private static final Map<String, Proxy> proxyMap = new HashMap<String, Proxy>();

    public DashboardManager(AlexandriaUiBox box, UISession session, String dashboard, Driver driver) {
        this.box = box;
        this.session = session;
        this.dashboard = dashboard;
        this.driver = driver;
    }

    public void listen() {
        if (this.listening()) {
            return;
        }
        DisplayRouteManager routeManager = this.box.routeManager();
        routeManager.get(DashboardsPathPattern, this::proxyGet);
        routeManager.get(DashboardPathPattern, this::proxyGet);
        routeManager.post(DashboardsPathPattern, this::proxyPost);
        routeManager.post(DashboardPathPattern, this::proxyPost);
        routeManagerReady = true;
    }

    public URL dashboardUrl() {
        try {
            return new URL(this.session.browser().baseUrl() + this.dashboardPath());
        }
        catch (MalformedURLException e) {
            return null;
        }
    }

    private boolean listening() {
        return routeManagerReady;
    }

    private Proxy proxy(String sessionId) {
        if (!proxyMap.containsKey(sessionId)) {
            proxyMap.put(sessionId, this.driver != null ? this.driver.run(this.program()) : null);
        }
        return proxyMap.get(sessionId);
    }

    private Program program() {
        Program result = new Program().name(this.dashboard);
        result.parameters().put("LocalUrlParameter", this.dashboardUrl());
        return result;
    }

    private String dashboardPath() {
        return String.format(DashboardPath, this.dashboard);
    }

    private void proxyGet(UISparkManager manager) {
        try {
            if (!this.validRequest(manager.request())) {
                return;
            }
            Proxy proxy = this.proxy(manager.request().session().id());
            if (proxy == null) {
                return;
            }
            proxy.get(manager.request(), manager.response());
        }
        catch (Throwable ex) {
            try {
                PrintWriter writer = manager.response().raw().getWriter();
                writer.print("Could not load dashboard. Contact administrator.");
                writer.close();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    private void proxyPost(UISparkManager manager) {
        try {
            if (!this.validRequest(manager.request())) {
                return;
            }
            Proxy proxy = this.proxy(manager.request().session().id());
            if (proxy == null) {
                return;
            }
            proxy.post(manager.request(), manager.response());
        }
        catch (Network.NetworkException e) {
            Logger.debug(e.getMessage());
        }
    }

    private boolean validRequest(Request request) {
        String sessionId = request.session().id();
        return this.proxy(sessionId) != null;
    }
}

