/*
 * Decompiled with CFR 0.152.
 */
package io.intino.alexandria.ui.displays.components;

import io.intino.alexandria.Scale;
import io.intino.alexandria.Timetag;
import io.intino.alexandria.core.Box;
import io.intino.alexandria.ui.displays.components.AbstractTemporalSlider;
import io.intino.alexandria.ui.displays.components.Collection;
import io.intino.alexandria.ui.displays.components.slider.Ordinal;
import io.intino.alexandria.ui.displays.components.slider.ordinals.DayOrdinal;
import io.intino.alexandria.ui.displays.components.slider.ordinals.HourOrdinal;
import io.intino.alexandria.ui.displays.components.slider.ordinals.MinuteOrdinal;
import io.intino.alexandria.ui.displays.components.slider.ordinals.MonthOrdinal;
import io.intino.alexandria.ui.displays.components.slider.ordinals.YearOrdinal;
import io.intino.alexandria.ui.displays.events.ChangeEvent;
import io.intino.alexandria.ui.displays.notifiers.TemporalSliderNotifier;
import io.intino.alexandria.ui.model.TimeScale;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class TemporalSlider<DN extends TemporalSliderNotifier, B extends Box>
extends AbstractTemporalSlider<DN, B> {
    private Instant min;
    private Instant max;
    private List<Collection> collections = new ArrayList<Collection>();
    private Ordinal.Formatter customFormatter = null;

    public TemporalSlider(B box) {
        super(box);
    }

    @Override
    public void didMount() {
        super.didMount();
        this.updateRange();
    }

    public Instant min() {
        return this.min;
    }

    public Instant max() {
        return this.max;
    }

    public void value(Instant instant) {
        this.value(this.toLong(instant));
    }

    @Override
    public TemporalSlider ordinal(Ordinal ordinal) {
        super.ordinal(ordinal);
        this.updateRange();
        return this;
    }

    public TemporalSlider formatter(Ordinal.Formatter formatter) {
        this.customFormatter = formatter;
        return this;
    }

    public TemporalSlider bindTo(Collection ... collections) {
        this.collections = Arrays.asList(collections);
        return this;
    }

    public TemporalSlider range(Instant min, Instant max) {
        this._range(min, max);
        return this;
    }

    @Override
    void notifyChange() {
        super.notifyChange();
        this.notifyCollections();
    }

    @Override
    public String formattedValue() {
        Ordinal ordinal = this.ordinal();
        long value = this.millisOf(this.value());
        return ordinal != null ? (this.customFormatter != null ? this.customFormatter.format(value) : ordinal.formatter(this.language()).format(value)) : String.valueOf(value);
    }

    @Override
    public void selectOrdinal(String name) {
        Instant current = this.toInstant(this.millisOf(this.value()));
        super.selectOrdinal(name, this.toLong(this.timeScale(name), current));
    }

    public Timetag timetag() {
        LocalDateTime localDate = this.toInstant(this.millisOf(this.value())).atZone(ZoneOffset.UTC).toLocalDateTime();
        return Timetag.of(localDate, this.scale());
    }

    public Scale scale() {
        Ordinal ordinal = this.ordinal();
        if (ordinal instanceof YearOrdinal) {
            return Scale.Year;
        }
        if (ordinal instanceof MonthOrdinal) {
            return Scale.Month;
        }
        if (ordinal instanceof DayOrdinal) {
            return Scale.Day;
        }
        if (ordinal instanceof HourOrdinal) {
            return Scale.Hour;
        }
        if (ordinal instanceof MinuteOrdinal) {
            return Scale.Minute;
        }
        return Scale.Day;
    }

    protected TemporalSlider _range(Instant min, Instant max) {
        this.min = min;
        this.max = max;
        this.updateRange();
        return this;
    }

    private long millisOf(long value) {
        return this.timeScale().addTo(this.min, value).toEpochMilli();
    }

    private Instant toInstant(long millis) {
        return Instant.ofEpochMilli(millis);
    }

    private TimeScale timeScale() {
        return this.timeScale(this.ordinal().name());
    }

    private TimeScale timeScale(String ordinal) {
        return TimeScale.valueOf(ordinal);
    }

    private void notifyCollections() {
        this.collections.forEach(c -> c.filter(this.timetag()));
    }

    @Override
    void updateRange() {
        Ordinal ordinal = this.ordinal();
        if (ordinal == null) {
            return;
        }
        long count = this.toLong(this.max);
        this._range(0L, count);
        if (this.notifier != null) {
            ((TemporalSliderNotifier)this.notifier).refreshRange(this.rangeSchema());
            ((TemporalSliderNotifier)this.notifier).refreshToolbar(this.toolbarState());
        }
    }

    @Override
    void notifyListener() {
        if (this.changeListener() == null) {
            return;
        }
        this.changeListener().accept(new ChangeEvent(this, this.toInstant(this.millisOf(this.value()))));
    }

    private long toLong(Instant instant) {
        return this.toLong(this.timeScale(), instant);
    }

    private long toLong(TimeScale timeScale, Instant instant) {
        return timeScale.instantsBetween(this.min, instant) - 1L;
    }
}

