/*
 * Decompiled with CFR 0.152.
 */
package io.intino.alexandria.ui.displays.components;

import io.intino.alexandria.core.Box;
import io.intino.alexandria.schemas.MapCollectionSetup;
import io.intino.alexandria.ui.Asset;
import io.intino.alexandria.ui.displays.Display;
import io.intino.alexandria.ui.displays.components.AbstractMap;
import io.intino.alexandria.ui.displays.components.Item;
import io.intino.alexandria.ui.displays.components.collection.Collection;
import io.intino.alexandria.ui.displays.components.collection.behaviors.CollectionBehavior;
import io.intino.alexandria.ui.displays.components.collection.behaviors.MapCollectionBehavior;
import io.intino.alexandria.ui.displays.components.collection.builders.PlaceMarkBuilder;
import io.intino.alexandria.ui.displays.events.AddItemEvent;
import io.intino.alexandria.ui.displays.notifiers.MapNotifier;
import io.intino.alexandria.ui.model.Datasource;
import io.intino.alexandria.ui.model.PlaceMark;
import io.intino.alexandria.ui.model.datasource.MapDatasource;
import java.net.URL;
import java.util.List;

public abstract class Map<B extends Box, ItemComponent extends Item, Item>
extends AbstractMap<MapNotifier, B>
implements Collection<ItemComponent, PlaceMark<Item>> {
    private Type type;
    private URL kmlLayer = null;
    private URL icon = null;

    public Map(B box) {
        super(box);
    }

    @Override
    public void didMount() {
        ((MapNotifier)this.notifier).setup(this.setupSchema());
        this.notifyReady();
    }

    @Override
    public <D extends Datasource> void source(D source) {
        this.source(source, new MapCollectionBehavior(this));
    }

    @Override
    public ItemComponent add(PlaceMark<Item> itemPlaceMark) {
        Item component = (Item)this.create(itemPlaceMark);
        this.addPromise(component, "rows");
        this.promisedChildren().forEach(this::register);
        List<Display> children = this.children();
        int i = 0;
        while (i < children.size()) {
            int index = i++;
            this.addItemListener().ifPresent(l -> l.accept(this.itemEvent((Display)children.get(index), index)));
        }
        this.notifyRefresh();
        return (ItemComponent)component;
    }

    @Override
    public List<ItemComponent> add(List<PlaceMark<Item>> placeMarks) {
        return null;
    }

    @Override
    public ItemComponent insert(PlaceMark<Item> itemPlaceMark, int index) {
        return null;
    }

    @Override
    public List<ItemComponent> insert(List<PlaceMark<Item>> placeMarks, int from) {
        return null;
    }

    protected Map _type(Type type) {
        this.type = type;
        return this;
    }

    protected Map _kmlLayer(URL layer) {
        this.type = Type.Kml;
        this.kmlLayer = layer;
        return this;
    }

    protected Map _icon(URL icon) {
        this.icon = icon;
        return this;
    }

    @Override
    protected AddItemEvent itemEvent(Display display, int index) {
        return new AddItemEvent(this, (Item)display, ((Item)display).item(), index);
    }

    @Override
    void setup() {
        MapDatasource source = (MapDatasource)this.source();
        if (source == null && this.type != Type.Kml) {
            return;
        }
        if (source != null) {
            Object behavior = this.behavior();
            ((CollectionBehavior)behavior).setup((MapDatasource)source);
        }
        ((MapNotifier)this.notifier).setup(this.setupSchema());
        this.notifyReady();
    }

    public void refreshPlaceMarks(List<PlaceMark<Item>> placeMarks) {
        ((MapNotifier)this.notifier).placeMarks(PlaceMarkBuilder.buildList(placeMarks, this.baseAssetUrl()));
    }

    public void showPlaceMark(long pos) {
        MapCollectionBehavior behavior = (MapCollectionBehavior)this.behavior();
        behavior.showPlaceMark(pos);
    }

    private MapCollectionSetup setupSchema() {
        MapCollectionSetup setup = new MapCollectionSetup();
        if (this.behavior() != null) {
            setup.itemCount(((CollectionBehavior)this.behavior()).itemCount());
        }
        if (this.type == Type.Kml) {
            setup.kmlLayer(Asset.toResource(this.baseAssetUrl(), this.kmlLayer).toUrl().toString());
        }
        if (this.icon != null) {
            setup.icon(Asset.toResource(this.baseAssetUrl(), this.icon).toUrl().toString());
        }
        return setup;
    }

    public static enum Type {
        Cluster,
        Kml,
        Heatmap;

    }
}

