/*
 * Decompiled with CFR 0.152.
 */
package io.intino.alexandria.ui.displays.components;

import com.auth0.jwt.algorithms.Algorithm;
import io.intino.alexandria.core.Box;
import io.intino.alexandria.schemas.DashboardMetabaseInfo;
import io.intino.alexandria.ui.displays.components.AbstractDashboardMetabase;
import io.intino.alexandria.ui.displays.notifiers.DashboardMetabaseNotifier;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.Date;
import java.util.stream.Collectors;
import org.apache.commons.codec.binary.Base64;

public class DashboardMetabase<DN extends DashboardMetabaseNotifier, B extends Box>
extends AbstractDashboardMetabase<DN, B> {
    private String url;
    private String secretKey;
    private int dashboard = -1;
    private boolean bordered;
    private boolean titled;
    private Theme theme = Theme.Light;
    private static final String Header = "{\"alg\":\"HS256\",\"typ\":\"JWT\"}";
    private static final String Payload = "{\"resource\":{\"dashboard\":%d},\"params\":{%s},\"iat\":%d}";

    public DashboardMetabase(B box) {
        super(box);
    }

    public DashboardMetabase<DN, B> url(String url) {
        this._url(url);
        return this;
    }

    public DashboardMetabase<DN, B> secretKey(String key) {
        this._secretKey(key);
        return this;
    }

    public DashboardMetabase<DN, B> dashboard(int id) {
        this._dashboard(id);
        return this;
    }

    public DashboardMetabase<DN, B> bordered(boolean bordered) {
        this._bordered(bordered);
        return this;
    }

    public DashboardMetabase<DN, B> titled(boolean titled) {
        this._titled(this.bordered);
        return this;
    }

    public DashboardMetabase<DN, B> theme(Theme theme) {
        this._theme(theme);
        return this;
    }

    protected DashboardMetabase<DN, B> _url(String url) {
        this.url = url;
        return this;
    }

    protected DashboardMetabase<DN, B> _secretKey(String key) {
        this.secretKey = key;
        return this;
    }

    protected DashboardMetabase<DN, B> _dashboard(int id) {
        this.dashboard = id;
        return this;
    }

    protected DashboardMetabase<DN, B> _bordered(boolean bordered) {
        this.bordered = bordered;
        return this;
    }

    protected DashboardMetabase<DN, B> _titled(boolean titled) {
        this.titled = titled;
        return this;
    }

    protected DashboardMetabase<DN, B> _theme(Theme theme) {
        this.theme = theme;
        return this;
    }

    @Override
    public void refresh() {
        if (!this.check()) {
            return;
        }
        ((DashboardMetabaseNotifier)this.notifier).refresh(new DashboardMetabaseInfo().location(this.location()));
    }

    private String location() {
        String header = this.base64(Header);
        String payload = this.base64(this.payload());
        String signature = DashboardMetabase.base64(this.sign(header, payload));
        String token = header + "." + payload + "." + signature;
        return this.url + "/embed/dashboard/" + token + "#bordered=" + this.bordered + "&titled=" + this.titled + (this.theme == Theme.Dark ? "&theme=night" : "");
    }

    private String payload() {
        Date expireDate = java.sql.Date.from(Instant.now().plus(120L, ChronoUnit.MINUTES));
        return String.format(Payload, this.dashboard, this.params(), expireDate.toInstant().toEpochMilli());
    }

    private String params() {
        return this.parameters().entrySet().stream().map(e -> "\"" + (String)e.getKey() + "\":\"" + e.getValue() + "\"").collect(Collectors.joining(","));
    }

    private byte[] sign(String header, String payload) {
        return Algorithm.HMAC256(this.secretKey.getBytes()).sign(header.getBytes(), payload.getBytes());
    }

    private boolean check() {
        if (this.dashboard == -1) {
            ((DashboardMetabaseNotifier)this.notifier).refreshError(this.translate("You must set dashboard id provided by Metabase"));
            return false;
        }
        if (this.url == null || this.url.isEmpty()) {
            ((DashboardMetabaseNotifier)this.notifier).refreshError(this.translate("You must set the url where Metabase instance is running"));
            return false;
        }
        if (this.secretKey == null || this.secretKey.isEmpty()) {
            ((DashboardMetabaseNotifier)this.notifier).refreshError(this.translate("You must set the secret key provided by Metabase"));
            return false;
        }
        return true;
    }

    private String base64(String text) {
        return DashboardMetabase.base64(text.getBytes());
    }

    public static String base64(byte[] data) {
        byte[] encode = new Base64().encode(data);
        for (int i = 0; i < encode.length; ++i) {
            if (encode[i] == 43) {
                encode[i] = 45;
                continue;
            }
            if (encode[i] != 47) continue;
            encode[i] = 95;
        }
        return new String(encode).replace("=", "");
    }

    public static enum Theme {
        Dark,
        Light;

    }
}

