/*
 * Decompiled with CFR 0.152.
 */
package io.intino.alexandria.ui.displays.components;

import io.intino.alexandria.Timetag;
import io.intino.alexandria.core.Box;
import io.intino.alexandria.schemas.CollectionSetup;
import io.intino.alexandria.ui.displays.Display;
import io.intino.alexandria.ui.displays.components.AbstractCollection;
import io.intino.alexandria.ui.displays.components.collection.CollectionItemDisplay;
import io.intino.alexandria.ui.displays.components.collection.behaviors.CollectionBehavior;
import io.intino.alexandria.ui.displays.events.AddItemEvent;
import io.intino.alexandria.ui.displays.events.Event;
import io.intino.alexandria.ui.displays.events.Listener;
import io.intino.alexandria.ui.displays.events.SelectionEvent;
import io.intino.alexandria.ui.displays.events.SelectionListener;
import io.intino.alexandria.ui.displays.events.collection.AddItemListener;
import io.intino.alexandria.ui.displays.events.collection.RefreshCountEvent;
import io.intino.alexandria.ui.displays.events.collection.RefreshCountListener;
import io.intino.alexandria.ui.displays.events.collection.RefreshEvent;
import io.intino.alexandria.ui.displays.events.collection.RefreshListener;
import io.intino.alexandria.ui.displays.notifiers.CollectionNotifier;
import io.intino.alexandria.ui.model.Datasource;
import io.intino.alexandria.ui.model.datasource.Filter;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Timer;
import java.util.TimerTask;
import java.util.function.Function;
import java.util.stream.Collectors;

public abstract class Collection<DN extends CollectionNotifier, B extends Box>
extends AbstractCollection<DN, B> {
    private CollectionBehavior behavior;
    private Datasource source;
    private List<SelectionListener> selectionListeners = new ArrayList<SelectionListener>();
    private AddItemListener addItemListener;
    private List<RefreshListener> refreshListeners = new ArrayList<RefreshListener>();
    private List<RefreshCountListener> refreshItemCountListeners = new ArrayList<RefreshCountListener>();
    private List<Listener> readyListeners = new ArrayList<Listener>();
    private boolean ready = false;
    private boolean allowMultiSelection = false;
    private List<String> selection;

    public Collection(B box) {
        super(box);
    }

    @Override
    public void didMount() {
        ((CollectionNotifier)this.notifier).setup(new CollectionSetup().itemCount(this.behavior.itemCount()));
        if (this.selection != null) {
            ((CollectionNotifier)this.notifier).refreshSelection(this.selection);
        }
        this.notifyReady();
    }

    public abstract <D extends Datasource> void source(D var1);

    Collection<DN, B> source(Datasource source, CollectionBehavior behavior) {
        this.source = source;
        this.behavior = behavior;
        this.setup();
        return this;
    }

    <CB extends CollectionBehavior> CB behavior() {
        return (CB)this.behavior;
    }

    public void onAddItem(AddItemListener listener) {
        this.addItemListener = listener;
    }

    public void onRefresh(RefreshListener listener) {
        this.refreshListeners.add(listener);
    }

    public void onRefreshItemCount(RefreshCountListener listener) {
        this.refreshItemCountListeners.add(listener);
    }

    public void unRefresh(RefreshListener listener) {
        this.refreshListeners.remove(listener);
    }

    public void onReady(Listener listener) {
        this.readyListeners.add(listener);
    }

    @Override
    public void init() {
        super.init();
        this.setup();
    }

    public void reload() {
        if (this.behavior == null) {
            return;
        }
        List<Integer> selectedIndexList = this.itemsIndexOf(this.selection);
        this.behavior.reload();
        this.notifyRefreshItemCount();
        this.refreshSelection(selectedIndexList);
    }

    public boolean ready() {
        return this.ready;
    }

    public <D extends Datasource> D source() {
        return (D)this.source;
    }

    public void clearFilters() {
        this.behavior.clearFilters();
        this.notifyRefreshItemCount();
    }

    public String condition() {
        if (this.behavior == null) {
            return null;
        }
        return this.behavior.condition();
    }

    public List<Filter> filters() {
        if (this.behavior == null) {
            return Collections.emptyList();
        }
        return this.behavior.filters();
    }

    public void filter(String grouping, List<String> groups) {
        if (this.behavior == null) {
            return;
        }
        this.behavior.filter(grouping, groups);
        this.notifyRefreshItemCount();
    }

    public void filter(Map<String, List<String>> groupings) {
        if (this.behavior == null) {
            return;
        }
        this.behavior.filter(groupings);
        this.notifyRefreshItemCount();
    }

    public void filter(String grouping, Instant from, Instant to) {
        if (this.behavior == null) {
            return;
        }
        this.behavior.filter(grouping, from, to);
        this.notifyRefreshItemCount();
    }

    public void filter(String condition) {
        if (this.behavior == null) {
            return;
        }
        this.behavior.condition(condition);
        this.notifyRefreshItemCount();
    }

    public void filter(Timetag timetag) {
        if (this.behavior == null) {
            return;
        }
        this.behavior.timetag(timetag);
        this.notifyRefreshItemCount();
    }

    public void removeFilter(String grouping) {
        this.behavior.removeFilter(grouping);
        this.notifyRefreshItemCount();
    }

    public void sortings(List<String> sortings) {
        this.behavior.sortings(sortings);
    }

    public void addSorting(String sorting) {
        this.behavior.addSorting(sorting);
    }

    public void removeSorting(String sorting) {
        this.behavior.removeSorting(sorting);
    }

    public <T> List<T> items(String ... sortings) {
        return this.behavior.items(sortings);
    }

    public long itemCount() {
        return this.behavior.itemCount();
    }

    public boolean allowMultiSelection() {
        return this.allowMultiSelection;
    }

    public void allowMultiSelection(boolean value) {
        this.allowMultiSelection = value;
        ((CollectionNotifier)this.notifier).refreshAllowMultiSelection(value);
    }

    public List<String> selection() {
        return this.selection;
    }

    public void selection(List<String> selection) {
        this.selection = selection;
        new ArrayList<SelectionListener>(this.selectionListeners).forEach(l -> l.accept(new SelectionEvent(this, this.itemsOf(selection))));
        ((CollectionNotifier)this.notifier).refreshSelection(selection);
    }

    public int findItem(Function<Object, Boolean> checker) {
        List<Display> children = this.children();
        for (int index = 0; index < children.size(); ++index) {
            if (!checker.apply(this.itemOf(children.get(index))).booleanValue()) continue;
            return index;
        }
        return -1;
    }

    public void select(int index) {
        List<Display> children = this.children();
        if (children.size() <= 0) {
            return;
        }
        if (index < 0) {
            return;
        }
        if (index > children.size() - 1) {
            return;
        }
        this.selection(Collections.singletonList(children.get(index).id()));
    }

    public void refresh(int index, Object item) {
        List<Display> children = this.children();
        if (children.size() <= 0) {
            return;
        }
        if (index < 0) {
            return;
        }
        if (index > children.size() - 1) {
            return;
        }
        ((CollectionItemDisplay)((Object)children.get(index))).update(item);
        this.addItemListener().ifPresent(l -> l.accept(this.itemEvent((Display)children.get(index), index)));
    }

    public void selectAll() {
        this.selection(this.children().stream().map(Display::id).collect(Collectors.toList()));
    }

    public boolean canSelectPreviousItem() {
        List<Display> children = this.children();
        if (children.size() <= 0) {
            return false;
        }
        int index = this.indexOfSelection();
        return index > 0;
    }

    public Object selectPreviousItem() {
        List<Display> children = this.children();
        if (children.size() <= 0) {
            return null;
        }
        int index = this.indexOfSelection() - 1;
        if (index < 0) {
            index = 0;
        }
        this.selection(Collections.singletonList(children.get(index).id()));
        return this.itemOf(children.get(index));
    }

    public boolean canSelectNextItem() {
        List<Display> children = this.children();
        if (children.size() <= 0) {
            return false;
        }
        int index = this.indexOfSelection();
        return index < children.size() - 1;
    }

    public Object selectNextItem() {
        List<Display> children = this.children();
        if (children.size() <= 0) {
            return null;
        }
        int index = this.indexOfSelection() + 1;
        if (index >= children.size()) {
            index = children.size() - 1;
        }
        this.selection(Collections.singletonList(children.get(index).id()));
        return this.itemOf(children.get(index));
    }

    private List<Object> itemsOf(List<String> selection) {
        return this.children().stream().filter((? super T d) -> selection.contains(d.id())).map(this::itemOf).collect(Collectors.toList());
    }

    private List<Integer> itemsIndexOf(List<String> selection) {
        if (selection == null) {
            return Collections.emptyList();
        }
        ArrayList<Integer> indexList = new ArrayList<Integer>();
        for (int i = 0; i < this.children().size(); ++i) {
            if (!selection.contains(this.children().get(i).id())) continue;
            indexList.add(i);
        }
        return indexList;
    }

    @Override
    public List<Display> children() {
        return super.children().stream().filter((? super T c) -> c instanceof CollectionItemDisplay).collect(Collectors.toList());
    }

    protected Object itemOf(Display display) {
        return display instanceof CollectionItemDisplay ? ((CollectionItemDisplay)((Object)display)).item() : null;
    }

    @Override
    public void clear() {
        this.clear("rows");
    }

    public void loading(boolean value) {
        ((CollectionNotifier)this.notifier).refreshLoading(value);
    }

    protected void addSelectionListener(SelectionListener listener) {
        this.selectionListeners.add(listener);
    }

    protected void removeSelectionListener(SelectionListener listener) {
        this.selectionListeners.remove(listener);
    }

    protected abstract AddItemEvent itemEvent(Display var1, int var2);

    protected void refreshSelection(final List<Integer> selectedIndexList) {
        if (selectedIndexList.isEmpty()) {
            return;
        }
        Timer timer = new Timer();
        timer.schedule(new TimerTask(){

            @Override
            public void run() {
                Collection.this.notifySelection(selectedIndexList);
            }
        }, 500L);
    }

    Optional<AddItemListener> addItemListener() {
        return Optional.ofNullable(this.addItemListener);
    }

    void notifyRefresh() {
        if (this.refreshListeners.size() <= 0) {
            return;
        }
        List items = this.children().stream().filter((? super T c) -> c instanceof CollectionItemDisplay).map(d -> ((CollectionItemDisplay)((Object)d)).item()).collect(Collectors.toList());
        this.refreshListeners.forEach(l -> l.accept(new RefreshEvent(this, items)));
    }

    void notifyRefreshItemCount() {
        long count = this.behavior.itemCount();
        ((CollectionNotifier)this.notifier).refreshItemCount(count);
        this.refreshItemCountListeners.forEach(l -> l.accept(new RefreshCountEvent(this, count)));
    }

    void notifyReady() {
        this.readyListeners.forEach(l -> l.accept(new Event(this)));
        this.ready = true;
    }

    void setup() {
        if (this.source == null) {
            return;
        }
        this.behavior.setup(this.source);
        ((CollectionNotifier)this.notifier).setup(new CollectionSetup().itemCount(this.behavior.itemCount()));
        this.notifyReady();
    }

    private int indexOfSelection() {
        if (this.selection == null || this.selection.size() <= 0) {
            return -1;
        }
        List<Display> children = this.children();
        for (int index = 0; index < children.size(); ++index) {
            if (!this.selection.contains(children.get(index).id())) continue;
            return index;
        }
        return -1;
    }

    private void notifySelection(List<Integer> indexList) {
        List<Display> children = this.children();
        if (children.size() <= 0) {
            return;
        }
        ((CollectionNotifier)this.notifier).refreshSelection(indexList.stream().map(i -> i < children.size() ? ((Display)children.get((int)i)).id() : null).filter(Objects::nonNull).collect(Collectors.toList()));
    }
}

