/*
 * Decompiled with CFR 0.152.
 */
package io.intino.alexandria.ui.displays.components;

import io.intino.alexandria.MimeTypes;
import io.intino.alexandria.core.Box;
import io.intino.alexandria.logger.Logger;
import io.intino.alexandria.ui.File;
import io.intino.alexandria.ui.displays.components.AbstractBaseImage;
import io.intino.alexandria.ui.displays.notifiers.BaseImageNotifier;
import java.net.MalformedURLException;
import java.net.URL;

public class BaseImage<DN extends BaseImageNotifier, B extends Box>
extends AbstractBaseImage<DN, B> {
    private URL value;
    private String mimeType;

    public BaseImage(B box) {
        super(box);
    }

    public URL value() {
        return this.value;
    }

    public void value(URL value) {
        this._value(value);
        this.refresh();
    }

    public void value(URL value, String mimeType) {
        this._value(value, mimeType != null ? mimeType : this.typeOf(value));
        this.refresh();
    }

    public void value(java.io.File file) {
        this._value(file);
        this.refresh();
    }

    public void value(File file) {
        this._value(file);
        this.refresh();
    }

    protected BaseImage<DN, B> _value(java.io.File file) {
        try {
            return this._value(this.value != null ? file.toURI().toURL() : null);
        }
        catch (MalformedURLException e) {
            Logger.error(e);
            return this;
        }
    }

    protected BaseImage<DN, B> _value(File file) {
        return file != null ? this._value(file.value(), file.mimeType()) : this._value(null, null);
    }

    protected BaseImage<DN, B> _value(URL value) {
        return this._value(value, this.typeOf(value));
    }

    protected BaseImage<DN, B> _value(URL value, String mimeType) {
        this.value = value;
        this.mimeType = mimeType;
        return this;
    }

    @Override
    public void init() {
        super.init();
        this.refresh();
    }

    @Override
    public void refresh() {
        ((BaseImageNotifier)this.notifier).refresh(this.serializedValue());
    }

    protected String typeOf(URL value) {
        return value != null ? MimeTypes.contentTypeOf(value) : null;
    }

    String serializedValue() {
        return null;
    }
}

