/*
 * Decompiled with CFR 0.152.
 */
package io.intino.alexandria.ui.displays.components;

import io.intino.alexandria.MimeTypes;
import io.intino.alexandria.core.Box;
import io.intino.alexandria.logger.Logger;
import io.intino.alexandria.schemas.FileInfo;
import io.intino.alexandria.ui.File;
import io.intino.alexandria.ui.displays.components.AbstractBaseFile;
import io.intino.alexandria.ui.displays.notifiers.BaseFileNotifier;
import io.intino.alexandria.ui.resources.Asset;
import java.net.MalformedURLException;
import java.net.URL;

public class BaseFile<DN extends BaseFileNotifier, B extends Box>
extends AbstractBaseFile<DN, B> {
    private URL value;
    private String mimeType;

    public BaseFile(B box) {
        super(box);
    }

    public URL value() {
        return this.value;
    }

    public void value(URL value) {
        this.value(value, null);
    }

    public void value(URL value, String mimeType) {
        this._value(value, mimeType != null ? mimeType : this.typeOf(value));
        this.refresh();
    }

    public void value(java.io.File file) {
        this._value(file);
        this.refresh();
    }

    public void value(File file) {
        this._value(file);
        this.refresh();
    }

    public String mimeType() {
        return this.mimeType;
    }

    protected BaseFile<DN, B> _value(java.io.File file) {
        try {
            return this._value(this.value != null ? file.toURI().toURL() : null);
        }
        catch (MalformedURLException e) {
            Logger.error(e);
            return this;
        }
    }

    protected BaseFile<DN, B> _value(File file) {
        return file != null ? this._value(file.value(), file.mimeType()) : this._value(null, null);
    }

    protected BaseFile<DN, B> _value(URL value) {
        return this._value(value, this.typeOf(value));
    }

    protected BaseFile<DN, B> _value(URL value, String mimeType) {
        this.value = value;
        this.mimeType = mimeType;
        return this;
    }

    protected FileInfo info() {
        FileInfo info = new FileInfo().value(this.serializedValue()).mimeType(this.mimeType);
        if (this.value != null) {
            info.filename(this.value.toString());
        }
        return info;
    }

    protected String typeOf(URL value) {
        return value != null ? MimeTypes.contentTypeOf(value) : null;
    }

    private String serializedValue() {
        return this.value != null ? Asset.toResource(this.baseAssetUrl(), this.value).toUrl().toString() : null;
    }
}

