/*
 * Decompiled with CFR 0.152.
 */
package io.intino.alexandria.triplestore;

import io.intino.alexandria.logger.Logger;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.stream.Stream;

public interface TripleStore {
    public static String lineOf(String ... triple) {
        return triple[0] + ";" + triple[1] + ";" + triple[2] + "\n";
    }

    public void put(String var1, String var2, Object var3);

    public Stream<String[]> all();

    public Stream<String[]> matches(String ... var1);

    public static class Builder {
        private OutputStream os;

        public Builder(OutputStream os) {
            this.os = new BufferedOutputStream(os);
        }

        private static byte[] bytesOf(String subject, String predicate, Object value) {
            return TripleStore.lineOf(subject, predicate, value.toString()).getBytes();
        }

        public Builder put(String subject, String predicate, Object value) {
            try {
                this.os.write(Builder.bytesOf(subject, predicate, value));
            }
            catch (IOException e) {
                Logger.error(e);
            }
            return this;
        }

        public void close() {
            try {
                this.os.close();
            }
            catch (IOException e) {
                Logger.error(e);
            }
        }
    }
}

