/*
 * Decompiled with CFR 0.152.
 */
package io.intino.alexandria.triplestore;

import io.intino.alexandria.logger.Logger;
import io.intino.alexandria.triplestore.MemoryTripleStore;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.InputStream;

public class FileTripleStore
extends MemoryTripleStore {
    private final File file;

    public FileTripleStore(File file) {
        super(FileTripleStore.inputStreamOf(file));
        this.file = file;
    }

    private static InputStream inputStreamOf(File file) {
        if (!file.exists()) {
            return new ByteArrayInputStream(new byte[0]);
        }
        try {
            return new FileInputStream(file);
        }
        catch (FileNotFoundException ignored) {
            return null;
        }
    }

    public File file() {
        return this.file;
    }

    public synchronized void save() {
        try {
            this.file.getParentFile().mkdirs();
            this.save(new FileOutputStream(this.file));
        }
        catch (FileNotFoundException e) {
            Logger.error(e);
        }
    }
}

