/*
 * Decompiled with CFR 0.152.
 */
package io.intino.alexandria.sealing;

import io.intino.alexandria.Fingerprint;
import io.intino.alexandria.datalake.file.FS;
import io.intino.alexandria.led.LedReader;
import io.intino.alexandria.led.LedStream;
import io.intino.alexandria.led.Transaction;
import io.intino.alexandria.led.buffers.store.ByteStore;
import io.intino.alexandria.led.util.LedUtils;
import io.intino.alexandria.logger.Logger;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.Comparator;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class TransactionSessionManager {
    public static void seal(File stageFolder, File transactionsStore, File tempFolder) {
        try {
            AtomicInteger processed = new AtomicInteger(0);
            AtomicInteger processedPerc = new AtomicInteger(0);
            ExecutorService pool = Executors.newFixedThreadPool(Math.max(4, Runtime.getRuntime().availableProcessors() / 2));
            List files = TransactionSessionManager.transactionSessions(stageFolder).sorted(Comparator.comparing(File::getName)).collect(Collectors.toList());
            if (!files.isEmpty()) {
                Logger.info("Sealing transactions...");
            }
            files.stream().map(e -> () -> {
                TransactionSessionManager.sealSession(transactionsStore, e, tempFolder);
                TransactionSessionManager.notifyProcess(processed, processedPerc, files.size());
            }).forEach(pool::execute);
            pool.shutdown();
            pool.awaitTermination(1L, TimeUnit.DAYS);
            if (!files.isEmpty()) {
                Logger.info("Seal of transactions finished!");
            }
            TransactionSessionManager.deleteDirectory(tempFolder);
        }
        catch (InterruptedException e2) {
            Logger.error(e2);
        }
    }

    private static void notifyProcess(AtomicInteger processed, AtomicInteger currentPerc, int total) {
        int processedPerc = Math.round((float)processed.incrementAndGet() / (float)total * 100.0f);
        if (processedPerc / 10 > processed.get() / 10) {
            Logger.info("Sealed " + processedPerc + "% of transactions");
        }
        currentPerc.set(processedPerc);
    }

    private static void sealSession(File transactionStore, File session, File tempFolder) {
        try {
            File sorted = TransactionSessionManager.sort(session, tempFolder);
            File destination = TransactionSessionManager.datalakeFile(transactionStore, TransactionSessionManager.fingerprintOf(session));
            if (destination.exists()) {
                TransactionSessionManager.merge(destination, sorted, tempFolder);
                sorted.delete();
            } else {
                Files.move(sorted.toPath(), destination.toPath(), new CopyOption[0]);
            }
            session.renameTo(new File(session.getAbsolutePath() + ".treated"));
        }
        catch (IOException e) {
            Logger.error(e);
        }
    }

    private static void merge(File destination, File session, File tempFolder) {
        try {
            File temp = Files.createTempFile(tempFolder.toPath(), "seal", ".led", new FileAttribute[0]).toFile();
            LedStream.merged(Stream.of(new LedReader(destination).read(SealTransacion::new), new LedReader(session).read(SealTransacion::new))).serialize(temp);
            FS.copyInto(temp, new FileInputStream(session));
            temp.delete();
        }
        catch (IOException e) {
            Logger.error(e);
        }
    }

    private static Stream<File> transactionSessions(File stage) {
        return FS.allFilesIn(stage, f -> f.getName().endsWith(".led.session") && (float)f.length() > 0.0f);
    }

    private static File datalakeFile(File eventStoreFolder, Fingerprint fingerprint) {
        File ledFile = new File(eventStoreFolder, fingerprint.toString() + ".led");
        ledFile.getParentFile().mkdirs();
        return ledFile;
    }

    private static Fingerprint fingerprintOf(File file) {
        return new Fingerprint(TransactionSessionManager.cleanedNameOf(file));
    }

    private static File sort(File transactionSession, File tempFolder) {
        File file = new File(transactionSession.getParentFile(), transactionSession.getName() + ".sort");
        LedUtils.sort((File)new File(tempFolder, "Chunks_" + transactionSession.getName() + "_" + Thread.currentThread().getName()), (File)transactionSession, (File)file, (int)1000000);
        return file;
    }

    private static String cleanedNameOf(File file) {
        return file.getName().substring(0, file.getName().indexOf("#")).replace("-", "/").replace(".led.session", "");
    }

    private static void deleteDirectory(File directoryToBeDeleted) {
        File[] allContents = directoryToBeDeleted.listFiles();
        if (allContents != null) {
            for (File file : allContents) {
                TransactionSessionManager.deleteDirectory(file);
            }
        }
        directoryToBeDeleted.delete();
    }

    private static class SealTransacion
    extends Transaction {
        public SealTransacion(ByteStore store) {
            super(store);
        }

        protected long id() {
            return SealTransacion.idOf((Transaction)this);
        }

        public int size() {
            return (int)this.bitBuffer.byteSize();
        }
    }
}

