/*
 * Decompiled with CFR 0.152.
 */
package io.intino.alexandria.sealing;

import io.intino.alexandria.Fingerprint;
import io.intino.alexandria.Session;
import io.intino.alexandria.datalake.file.FS;
import io.intino.alexandria.logger.Logger;
import io.intino.alexandria.sealing.SetSessionFileReader;
import io.intino.alexandria.triplestore.MemoryTripleStore;
import io.intino.alexandria.triplestore.TripleStore;
import io.intino.alexandria.zet.ZetReader;
import io.intino.alexandria.zet.ZetStream;
import io.intino.alexandria.zet.ZetWriter;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

class SetSessionManager {
    private static final DecimalFormat FORMATTER = new DecimalFormat("#.##");
    private final List<File> files;
    private final File setStoreFolder;
    private final File tempFolder;
    private int count = 1;

    private SetSessionManager(List<File> files, File setStoreFolder, File tempFolder) {
        this.files = files;
        this.setStoreFolder = setStoreFolder;
        this.tempFolder = tempFolder;
    }

    static void seal(File stageFolder, File setStoreFolder, File tempFolder) {
        new SetSessionManager(SetSessionManager.sessionsOf(stageFolder), setStoreFolder, tempFolder).seal();
    }

    private static List<File> sessionsOf(File stageFolder) {
        return FS.allFilesIn(stageFolder, f -> f.getName().endsWith(".session")).collect(Collectors.toList());
    }

    private static File fileFor(Session session, File stageFolder) {
        return new File(stageFolder, SetSessionManager.filename(session));
    }

    private static String filename(Session session) {
        return session.name() + ".session";
    }

    private static String extensionOf(Session.Type type) {
        return "." + type.name() + ".session";
    }

    private void seal() {
        this.sealSetSessions();
        this.sealSetMetadataSessions();
    }

    private void sealSetMetadataSessions() {
        HashMap map = new HashMap();
        try {
            this.loadSetMetadataSessions().forEach((key, value) -> {
                String[] triple = (String[])value.all().flatMap(Arrays::stream).toArray(String[]::new);
                if (triple.length > 0) {
                    this.processTriple(triple, map);
                }
                this.markTreated((File)key);
            });
        }
        catch (Throwable e) {
            Logger.error(e);
        }
        map.values().forEach(TripleStore.Builder::close);
    }

    private void processTriple(String[] triple, Map<File, TripleStore.Builder> map) {
        Fingerprint fingerprint = new Fingerprint(triple[0]);
        this.tripleStoreFor(this.metadataFileOf(fingerprint), map).put(fingerprint.set(), triple[1], triple[2]);
    }

    private File metadataFileOf(Fingerprint fingerprint) {
        File file = new File(this.setStoreFolder, fingerprint.tank() + "/" + fingerprint.timetag() + "/.metadata");
        file.getParentFile().mkdirs();
        return file;
    }

    private TripleStore.Builder tripleStoreFor(File file, Map<File, TripleStore.Builder> map) {
        if (!map.containsKey(file)) {
            try {
                map.put(file, new TripleStore.Builder(new FileOutputStream(file, true)));
            }
            catch (FileNotFoundException e) {
                Logger.error(e);
            }
        }
        return map.get(file);
    }

    private Map<File, MemoryTripleStore> loadSetMetadataSessions() {
        return this.files.parallelStream().filter(f -> f.getName().endsWith(SetSessionManager.extensionOf(Session.Type.setMetadata))).collect(Collectors.toMap(f -> f, f -> new MemoryTripleStore(this.inputStreamOf((File)f)), (a, b) -> b));
    }

    private InputStream inputStreamOf(File file) {
        try {
            return new BufferedInputStream(new FileInputStream(file));
        }
        catch (IOException e) {
            Logger.error(e);
            return null;
        }
    }

    private void sealSetSessions() {
        List<SetSessionFileReader> readers = this.setSessionReaders();
        int size = readers.stream().mapToInt(SetSessionFileReader::size).sum();
        readers.forEach(r -> {
            this.sealFingerprints(readers, size, (SetSessionFileReader)r);
            this.markTreated(r.file());
        });
    }

    private void markTreated(File file) {
        file.renameTo(new File(file.getAbsolutePath() + ".treated"));
    }

    private void sealFingerprints(List<SetSessionFileReader> readers, int size, SetSessionFileReader r) {
        r.fingerprints().parallelStream().forEach(fp -> {
            if (this.count % 10000 == 0) {
                Logger.info(FORMATTER.format((double)this.count * 100.0 / (double)size) + "%");
            }
            this.seal((Fingerprint)fp, readers);
            this.deleteIndex((Fingerprint)fp);
            ++this.count;
        });
    }

    private void deleteIndex(Fingerprint fp) {
        File file = new File(this.fileOf(fp).getParent(), ".mapp");
        if (file.exists()) {
            file.delete();
        }
    }

    private List<SetSessionFileReader> setSessionReaders() {
        return this.setSessions().map(this::setSessionReader).collect(Collectors.toList());
    }

    private SetSessionFileReader setSessionReader(File file) {
        try {
            return new SetSessionFileReader(file);
        }
        catch (IOException e) {
            Logger.error(e);
            return null;
        }
    }

    private void seal(Fingerprint fingerprint, List<SetSessionFileReader> readers) {
        try {
            File setFile = this.fileOf(fingerprint);
            File tempFile = this.merge(fingerprint, readers);
            Files.move(tempFile.toPath(), setFile.toPath(), StandardCopyOption.REPLACE_EXISTING);
        }
        catch (IOException e) {
            Logger.error(e);
        }
    }

    private File merge(Fingerprint fingerprint, List<SetSessionFileReader> readers) throws IOException {
        File tempFile = File.createTempFile(fingerprint.toString(), ".zet", this.tempFolder);
        List<ZetStream> streams = this.zetStreamsOf(fingerprint, readers);
        new ZetWriter(tempFile).write(streams.size() == 1 ? streams.get(0) : new ZetStream.Merge(streams));
        return tempFile;
    }

    private List<ZetStream> zetStreamsOf(Fingerprint fingerprint, List<SetSessionFileReader> readers) {
        List<ZetStream> streams = this.collectZetStreams(fingerprint, readers);
        File setFile = this.fileOf(fingerprint);
        if (setFile.exists()) {
            streams.add(new ZetReader(setFile));
        }
        return streams;
    }

    private List<ZetStream> collectZetStreams(Fingerprint fingerprint, List<SetSessionFileReader> readers) {
        ArrayList<ZetStream> list = new ArrayList<ZetStream>();
        for (SetSessionFileReader reader : readers) {
            list.addAll(reader.streamsOf(fingerprint));
        }
        return list;
    }

    private Stream<File> setSessions() {
        return this.files.stream().filter(f -> f.getName().endsWith(SetSessionManager.extensionOf(Session.Type.set)));
    }

    private File fileOf(Fingerprint fingerprint) {
        File file = new File(this.setStoreFolder, fingerprint + ".zet");
        file.getParentFile().mkdirs();
        return file;
    }

    private Set<Fingerprint> fingerPrintsIn(List<SetSessionFileReader> readers) {
        HashSet<Fingerprint> set = new HashSet<Fingerprint>();
        for (SetSessionFileReader reader : readers) {
            set.addAll(reader.fingerprints());
        }
        return set;
    }
}

