/*
 * Decompiled with CFR 0.152.
 */
package io.intino.alexandria.sealing;

import io.intino.alexandria.Fingerprint;
import io.intino.alexandria.Timetag;
import io.intino.alexandria.logger.Logger;
import io.intino.alexandria.zet.ZetReader;
import io.intino.alexandria.zet.ZetStream;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class SetSessionFileReader {
    private final File file;
    private final Map<Fingerprint, List<Chunk>> chunks;

    public SetSessionFileReader(File file) throws IOException {
        this.file = file;
        this.chunks = this.chunksIn(this.file);
    }

    public Set<Fingerprint> fingerprints() {
        return this.chunks.keySet();
    }

    public File file() {
        return this.file;
    }

    public int size() {
        return this.chunks.size();
    }

    public List<ZetStream> streamsOf(Fingerprint fingerprint) {
        ArrayList<ZetStream> zetStreams = new ArrayList<ZetStream>();
        for (Chunk chunk : this.chunks.getOrDefault(fingerprint, Collections.emptyList())) {
            zetStreams.add(chunk.stream());
        }
        return zetStreams;
    }

    private Map<Fingerprint, List<Chunk>> chunksIn(File file) throws IOException {
        HashMap<Fingerprint, List<Chunk>> chunks = new HashMap<Fingerprint, List<Chunk>>();
        this.fill(chunks, file);
        return chunks;
    }

    private void fill(Map<Fingerprint, List<Chunk>> chunks, File file) throws IOException {
        try {
            DataInputStream stream = new DataInputStream(new BufferedInputStream(new FileInputStream(file)));
            try {
                long position = 0L;
                while (true) {
                    byte[] fingerprint = this.readData(stream);
                    int size = this.skipData(stream);
                    Chunk chunk = this.chunkOf(fingerprint, (position += (long)(fingerprint.length + size + 8)) - (long)size, size);
                    if (!chunks.containsKey(chunk.fingerprint)) {
                        chunks.put(chunk.fingerprint, new ArrayList());
                    }
                    chunks.get(chunk.fingerprint).add(chunk);
                }
            }
            catch (Throwable throwable) {
                try {
                    stream.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (EOFException eOFException) {
            return;
        }
    }

    private Chunk chunkOf(byte[] fingerprint, long position, int size) {
        return this.chunkOf(new Fingerprint(new String(fingerprint)), position, size);
    }

    private Chunk chunkOf(Fingerprint fingerprint, long position, int size) {
        return new Chunk(fingerprint, position, size);
    }

    private byte[] readData(DataInputStream stream) throws IOException {
        int size = stream.readInt();
        byte[] data = new byte[size];
        stream.read(data);
        return data;
    }

    private int skipData(DataInputStream stream) throws IOException {
        int size = stream.readInt();
        stream.skipBytes(size);
        return size;
    }

    public class Chunk {
        private final Fingerprint fingerprint;
        private final long position;
        private final int size;

        Chunk(Fingerprint fingerprint, long position, int size) {
            this.fingerprint = fingerprint;
            this.position = position;
            this.size = size;
        }

        public String tank() {
            return this.fingerprint.tank();
        }

        public Timetag timetag() {
            return this.fingerprint.timetag();
        }

        public String set() {
            return this.fingerprint.set();
        }

        public ZetStream stream() {
            try {
                return new ZetReader(this.inputStream());
            }
            catch (IOException e) {
                Logger.error(e);
                return null;
            }
        }

        private ByteArrayInputStream inputStream() throws IOException {
            return new ByteArrayInputStream(this.buffer());
        }

        private byte[] buffer() throws IOException {
            try (RandomAccessFile access = new RandomAccessFile(SetSessionFileReader.this.file, "r");){
                byte[] buffer = new byte[this.size];
                access.seek(this.position);
                access.read(buffer);
                byte[] byArray = buffer;
                return byArray;
            }
        }
    }
}

