/*
 * Decompiled with CFR 0.152.
 */
package io.intino.alexandria.sealing;

import io.intino.alexandria.Session;
import io.intino.alexandria.datalake.file.FS;
import io.intino.alexandria.logger.Logger;
import io.intino.alexandria.sealing.Stage;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.stream.Stream;

class FileStage
implements Stage {
    private final File stageFolder;

    FileStage(File stageFolder) {
        this.stageFolder = stageFolder;
        this.stageFolder.mkdirs();
    }

    @Override
    public void push(Stream<Session> sessions) {
        sessions.forEach(s -> this.push((Session)s, this.stageFolder));
    }

    @Override
    public void clear() {
        FS.allFilesIn(this.stageFolder, file -> file.isFile() && this.isNotTreated(file)).forEach(f -> f.renameTo(new File(f.getAbsolutePath() + ".treated")));
        FS.foldersIn(this.stageFolder).filter(f -> !f.getName().equals("temp") && !f.getName().startsWith("treated.")).forEach(f -> f.renameTo(new File(f.getParentFile().getAbsolutePath() + File.separator + "treated." + f.getName())));
    }

    private boolean isNotTreated(File file) {
        return !file.getName().endsWith(".treated");
    }

    private void push(Session session, File stageFolder) {
        FS.copyInto(this.fileFor(session, stageFolder), session.inputStream());
    }

    private File fileFor(Session session, File stageFolder) {
        return new File(stageFolder, this.filename(session));
    }

    private String filename(Session session) {
        return session.name() + "." + session.type() + ".session";
    }

    @Override
    public Stream<Session> sessions() {
        return this.files().map(FileSession::new);
    }

    private Stream<File> files() {
        return FS.allFilesIn(this.stageFolder, this::sessions);
    }

    private boolean sessions(File file) {
        return file.isDirectory() || file.getName().endsWith(".session");
    }

    private static class FileSession
    implements Session {
        private final File file;
        private final Session.Type type;

        FileSession(File file) {
            this.file = file;
            this.type = this.typeOf(file.getName());
        }

        @Override
        public String name() {
            String name = this.file.getName();
            return name.substring(0, name.lastIndexOf("."));
        }

        private Session.Type typeOf(String filename) {
            return Arrays.stream(Session.Type.values()).filter(type -> filename.endsWith(this.extensionOf((Session.Type)((Object)type)))).findFirst().orElse(null);
        }

        private String extensionOf(Session.Type type) {
            return "." + type.name() + ".session";
        }

        @Override
        public Session.Type type() {
            return this.type;
        }

        @Override
        public InputStream inputStream() {
            return new BufferedInputStream(this.inputStreamOfFile());
        }

        private InputStream inputStreamOfFile() {
            try {
                return new FileInputStream(this.file);
            }
            catch (FileNotFoundException e) {
                Logger.error(e);
                return new ByteArrayInputStream(new byte[0]);
            }
        }
    }
}

