/*
 * Decompiled with CFR 0.152.
 */
package io.intino.alexandria.sealing;

import io.intino.alexandria.datalake.Datalake;
import io.intino.alexandria.datalake.file.FileDatalake;
import io.intino.alexandria.logger.Logger;
import io.intino.alexandria.sealing.EventSessionManager;
import io.intino.alexandria.sealing.SessionSealer;
import io.intino.alexandria.sealing.SetIndexer;
import io.intino.alexandria.sealing.SetSessionManager;
import java.io.File;
import java.io.IOException;
import java.util.List;

public class FileSessionSealer
implements SessionSealer {
    private final File stageFolder;
    private final FileDatalake datalake;
    private final File tempFolder;

    public FileSessionSealer(FileDatalake datalake, File stageFolder) {
        this(datalake, stageFolder, FileSessionSealer.tempFolder(stageFolder));
    }

    public FileSessionSealer(FileDatalake datalake, File stageFolder, File tempFolder) {
        this.datalake = datalake;
        this.stageFolder = stageFolder;
        this.tempFolder = tempFolder;
    }

    @Override
    public synchronized void seal(List<Datalake.EventStore.Tank> avoidSorting) {
        if (this.isSealing()) {
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        this.lock();
        try {
            this.sealEvents(avoidSorting);
            this.sealSets();
            this.makeSetIndexes();
        }
        catch (Throwable e) {
            Logger.error(e);
        }
        this.unlock();
    }

    private boolean isSealing() {
        return this.lockFile().exists();
    }

    private void sealEvents(List<Datalake.EventStore.Tank> avoidSorting) {
        EventSessionManager.seal(this.stageFolder, this.datalake.eventStoreFolder(), avoidSorting, this.tempFolder);
    }

    private void sealSets() {
        SetSessionManager.seal(this.stageFolder, this.datalake.setStoreFolder(), this.tempFolder);
    }

    private void makeSetIndexes() {
        new SetIndexer(this.datalake.setStoreFolder()).make();
    }

    private void lock() {
        try {
            this.lockFile().createNewFile();
        }
        catch (IOException e) {
            Logger.error(e);
        }
    }

    private void unlock() {
        this.lockFile().delete();
        this.notify();
    }

    private File lockFile() {
        return new File(this.datalake.root(), ".lock");
    }

    private static File tempFolder(File stageFolder) {
        File temp = new File(stageFolder, "temp");
        temp.mkdir();
        return temp;
    }
}

