/*
 * Decompiled with CFR 0.152.
 */
package io.intino.alexandria.sealing;

import io.intino.alexandria.logger.Logger;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.nio.file.Files;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import org.xerial.snappy.SnappyInputStream;
import org.xerial.snappy.SnappyOutputStream;

public class EventSorter {
    private final File file;
    private final File temp;
    private final List<Tuple> tuples;

    public EventSorter(File file, File tempFolder) throws IOException {
        this.file = file;
        this.temp = File.createTempFile("event", ".inl", tempFolder);
        this.tuples = new ArrayList<Tuple>();
    }

    void sort() throws IOException {
        this.sort(this.file);
    }

    void sort(File destination) throws IOException {
        try {
            this.read();
            this.tuples.sort(Comparator.comparing(t -> t.ts));
            this.write(this.outputStream(destination));
            Files.delete(this.temp.toPath());
        }
        catch (IOException io) {
            if (this.temp.exists()) {
                Logger.warn("Deleting inl temporal file " + this.file.getAbsolutePath());
                Files.delete(this.temp.toPath());
            }
            throw io;
        }
    }

    private void read() throws IOException {
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(this.inputStream()));
             BufferedWriter writer = new BufferedWriter(new FileWriter(this.temp));){
            String line;
            int offset = 0;
            int size = 0;
            Instant instant = null;
            while ((line = reader.readLine()) != null) {
                if (this.isTS(line)) {
                    instant = Instant.parse(line.substring(line.indexOf(":") + 1).trim());
                } else if (this.isMainHeader(line)) {
                    this.addTuple(instant, offset, size);
                    offset += size;
                    size = 0;
                }
                size += line.getBytes().length + 1;
                writer.write(line + "\n");
            }
            this.addTuple(instant, offset, size);
        }
    }

    private void write(OutputStream output) throws IOException {
        try (RandomAccessFile input = new RandomAccessFile(this.temp, "r");){
            for (Tuple t : this.tuples) {
                this.write(output, this.bytesOf(input, t));
            }
            output.flush();
            output.close();
        }
    }

    private void write(OutputStream output, byte[] bytes) {
        try {
            output.write(bytes);
        }
        catch (IOException e) {
            Logger.error(e);
        }
    }

    private OutputStream outputStream(File file) throws IOException {
        return new SnappyOutputStream(new FileOutputStream(file));
    }

    private byte[] bytesOf(RandomAccessFile accessFile, Tuple tuple) {
        try {
            return this.read(accessFile, (int)(tuple.next >> 32), new byte[(int)tuple.next]);
        }
        catch (IOException e) {
            Logger.error(e);
            return new byte[0];
        }
    }

    private byte[] read(RandomAccessFile accessFile, int offset, byte[] buffer) throws IOException {
        accessFile.seek(offset);
        accessFile.read(buffer);
        return buffer;
    }

    private void addTuple(Instant instant, int offset, int size) {
        if (instant == null) {
            return;
        }
        this.tuples.add(new Tuple(instant, ((long)offset << 32) + (long)size));
    }

    private boolean isTS(String line) {
        return line.startsWith("ts:");
    }

    private boolean isMainHeader(String line) {
        return line.startsWith("[") && !line.contains(".");
    }

    private InputStream inputStream() throws IOException {
        return new SnappyInputStream(new FileInputStream(this.file));
    }

    private static class Tuple {
        Instant ts;
        long next;

        public Tuple(Instant ts, long next) {
            this.ts = ts;
            this.next = next;
        }
    }
}

