/*
 * Decompiled with CFR 0.152.
 */
package io.intino.alexandria.proxy;

import io.intino.alexandria.proxy.Network;
import io.intino.alexandria.proxy.ProxyAdapter;
import java.io.IOException;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.nio.file.Paths;
import javax.servlet.ServletOutputStream;
import org.apache.http.Header;
import spark.Request;
import spark.Response;

public class Proxy {
    private URL localUrl;
    private URL remoteUrl;
    private ProxyAdapter adapter = null;
    String url;

    public Proxy(URL localUrl, URL remoteUrl) {
        this.localUrl = localUrl;
        this.remoteUrl = remoteUrl;
    }

    public Proxy adapter(ProxyAdapter adapter) {
        this.adapter = adapter;
        return this;
    }

    public void get(Request request, Response response) throws Network.NetworkException, URISyntaxException {
        Network network = new Network();
        String query = request.queryString();
        query = query == null ? "" : "?" + query;
        String uri = this.pathOf(request);
        this.url = this.remoteUrl + uri + query;
        byte[] content = network.sendGetString(this.url);
        this.fixHeaders(network, response);
        if (this.isText(network)) {
            String textContent = new String(content, StandardCharsets.UTF_8);
            if (this.isHtml(network)) {
                if (!request.uri().contains("iframe.html")) {
                    textContent = textContent.replaceAll(" src=\"", " src=\"" + this.localUrl + "/");
                }
                textContent = textContent.replaceAll(" href=\"", " href=\"" + this.localUrl + "/");
            }
            if (this.isCss(network)) {
                String subUri = uri.length() > 1 ? uri.substring(1) : uri;
                Path path = Paths.get(uri.substring(0, subUri.lastIndexOf("/") + 1), new String[0]).getParent();
                textContent = textContent.replaceAll("url\\(\\.\\./", "url(" + this.localUrl + path + "/");
            }
            content = textContent.getBytes();
        }
        this.writeResponse(response, content);
    }

    private boolean isText(Network network) {
        return this.isHtml(network) || this.isCss(network);
    }

    private boolean isHtml(Network network) {
        String contentType = this.contentType(network);
        return contentType != null && contentType.contains("text/html");
    }

    private boolean isCss(Network network) {
        String contentType = this.contentType(network);
        return contentType != null && contentType.contains("text/css");
    }

    private boolean isJs(Network network) {
        String contentType = this.contentType(network);
        return contentType != null && (contentType.contains("text/javascript") || contentType.contains("application/javascript"));
    }

    public void post(Request request, Response response) throws Network.NetworkException {
        Network network = new Network();
        String query = request.queryString();
        query = query == null ? "" : "?" + query;
        this.url = this.remoteUrl + this.pathOf(request) + query;
        StringBuilder params = new StringBuilder();
        for (String key : request.queryParams()) {
            String value = request.queryParams(key);
            params.append("&").append(key).append("=").append(this.adaptParameter(key, value));
        }
        if (params.length() > 0) {
            params = new StringBuilder(params.substring(1));
        }
        byte[] content = network.sendPostString(this.url, params.toString());
        this.fixHeaders(network, response);
        this.writeResponse(response, content);
    }

    private void fixHeaders(Network network, Response response) {
        response.removeCookie("JSESSIONID");
        Header[] headers = network.getLastHeaders();
        if (headers == null) {
            return;
        }
        for (Header header : headers) {
            if ("content-length".equalsIgnoreCase(header.getName()) || "Set-Cookie".equalsIgnoreCase(header.getName())) continue;
            response.header(header.getName(), header.getValue());
        }
    }

    private String contentType(Network network) {
        Header[] headers = network.getLastHeaders();
        if (headers == null) {
            return null;
        }
        for (Header header : headers) {
            if (!"content-type".equalsIgnoreCase(header.getName())) continue;
            return header.getValue();
        }
        return null;
    }

    private String pathOf(Request request) {
        String uri = this.format(request.uri());
        String path = this.removeAddressPath(request, this.localUrl.getPath());
        uri = uri.replace(path, "");
        uri = uri.replace(path.substring(0, path.lastIndexOf("/")), "");
        return uri;
    }

    private String format(String uri) {
        return uri.startsWith("//") ? uri.substring(1) : uri;
    }

    private String removeAddressPath(Request request, String path) {
        return path.replace(request.raw().getHeader("X-Forwarded-Path"), "");
    }

    private String adaptParameter(String key, String value) {
        if (this.adapter == null) {
            return value;
        }
        return this.adapter.adaptParameter(this.localUrl, this.remoteUrl, key, value);
    }

    private void writeResponse(Response response, byte[] content) throws Network.NetworkException {
        try {
            ServletOutputStream stream = response.raw().getOutputStream();
            response.raw().setContentLength(content.length);
            stream.write(content);
            stream.close();
        }
        catch (IOException e) {
            throw new Network.NetworkException(e);
        }
    }
}

