/*
 * Decompiled with CFR 0.152.
 */
package io.intino.alexandria.message.parser;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.util.Iterator;

public class MessageStream
implements Iterator<String>,
AutoCloseable {
    private final BufferedReader reader;
    private int last = 0;

    public MessageStream(InputStream stream) {
        this(stream, Charset.defaultCharset());
    }

    public MessageStream(InputStream stream, Charset charset) {
        this.reader = new BufferedReader(new InputStreamReader((InputStream)new BufferedInputStream(stream), charset));
        this.init();
    }

    @Override
    public boolean hasNext() {
        return this.last != -1;
    }

    @Override
    public void close() throws IOException {
        this.reader.close();
    }

    @Override
    public String next() {
        if (this.last == -1) {
            return null;
        }
        StringBuilder builder = new StringBuilder();
        try {
            int r;
            char current = '\u0000';
            while ((r = this.reader.read()) != -1 && (this.last != 10 || r != 91)) {
                current = (char)r;
                builder.append(current);
                this.last = current;
            }
            this.last = r;
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        if (builder.length() > 0) {
            builder.insert(0, '[');
        }
        return builder.toString().replace("\r\n", "\n");
    }

    private void init() {
        try {
            this.reader.read();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

