/*
 * Decompiled with CFR 0.152.
 */
package io.intino.alexandria.message;

import io.intino.alexandria.message.Message;
import io.intino.alexandria.message.parser.InlLexicon;
import io.intino.alexandria.message.parser.MessageStream;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import org.antlr.v4.runtime.CharStreams;
import org.antlr.v4.runtime.Token;

public class MessageReader
implements Iterator<Message>,
Iterable<Message> {
    private final MessageStream messageStream;
    private String current;

    public MessageReader(String str) {
        this(new ByteArrayInputStream(str.getBytes()));
    }

    public MessageReader(InputStream inputStream) {
        this.messageStream = new MessageStream(inputStream);
        if (this.messageStream.hasNext()) {
            this.current = this.messageStream.next();
        }
    }

    @Override
    public boolean hasNext() {
        return this.current != null && !this.current.isEmpty() && !this.current.isBlank();
    }

    @Override
    public Message next() {
        try {
            if (this.current == null || this.current.isEmpty() || this.current.isBlank()) {
                return null;
            }
            return this.nextMessage();
        }
        catch (Exception e) {
            Logger.getGlobal().severe(e.getMessage());
            return null;
        }
    }

    public void close() {
        try {
            this.messageStream.close();
        }
        catch (IOException e) {
            Logger.getGlobal().severe(e.getMessage());
        }
    }

    private Message nextMessage() {
        String next;
        ArrayList<Message> messageContexts = new ArrayList<Message>();
        messageContexts.add(this.nextMessage(this.current).getValue());
        while ((next = this.messageStream.next()) != null && this.isComponent(next)) {
            Map.Entry<Integer, Message> entry = this.nextMessage(next);
            this.add(messageContexts, entry.getKey(), entry.getValue());
            ((Message)messageContexts.get(entry.getKey() - 1)).add(entry.getValue());
        }
        this.current = next;
        return (Message)messageContexts.get(0);
    }

    private void add(List<Message> messageContexts, Integer level, Message value) {
        if (messageContexts.size() <= level) {
            messageContexts.add(level, value);
        } else {
            messageContexts.set(level, value);
        }
    }

    private boolean isComponent(String next) {
        return next.substring(0, next.indexOf(10)).contains(".");
    }

    private Map.Entry<Integer, Message> nextMessage(String next) {
        return this.getNextMessage(this.lexicon(next).iterator());
    }

    private Map.Entry<Integer, Message> getNextMessage(Iterator<Token> iterator) {
        Token current;
        while (iterator.hasNext() && (current = iterator.next()).getType() != 1) {
        }
        String type = this.readType(iterator);
        iterator.next();
        String[] contexts = type.split("\\.");
        Message message = new Message(contexts[contexts.length - 1]);
        this.readAttributes(message, iterator);
        return new AbstractMap.SimpleEntry<Integer, Message>(contexts.length - 1, message);
    }

    private String readType(Iterator<Token> iterator) {
        Token current;
        StringBuilder idb = new StringBuilder();
        while (iterator.hasNext() && (current = iterator.next()).getType() != 2) {
            idb.append(current.getText());
        }
        return idb.toString();
    }

    private void readAttributes(Message message, Iterator<Token> iterator) {
        Token id;
        while (iterator.hasNext() && (id = iterator.next()).getType() != 7) {
            String value;
            String attributeName = id.getText();
            iterator.next();
            Token next = iterator.next();
            if (this.isInLineValue(next)) {
                value = next.getText().substring(1);
                if (iterator.hasNext()) {
                    iterator.next();
                }
            } else {
                value = this.multiline(iterator, next);
            }
            message.set(attributeName, value);
        }
    }

    private boolean isInLineValue(Token next) {
        return next.getType() == 11;
    }

    private String multiline(Iterator<Token> iterator, Token last) {
        Token current = last;
        StringBuilder builder = new StringBuilder();
        while (iterator.hasNext() && current.getType() != 7) {
            current = iterator.next();
            if (current.getType() != 11) continue;
            builder.append("\n").append(current.getText());
        }
        return builder.toString().substring(1);
    }

    private List<Token> lexicon(String text) {
        InlLexicon lexer = new InlLexicon(CharStreams.fromString(text));
        return lexer.getAllTokens();
    }

    @Override
    public Iterator<Message> iterator() {
        return this;
    }
}

