/*
 * Decompiled with CFR 0.152.
 */
package io.intino.alexandria.message;

import io.intino.alexandria.message.Fields;
import io.intino.alexandria.message.Message;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

public class MessageBuilder {
    private static final String[] primitives = new String[]{"java.lang", "java.time"};

    public static Message toMessage(Object object) {
        return new MessageBuilder().build(object);
    }

    private Message build(Object object) {
        Message message = new Message(object.getClass().getSimpleName());
        for (Field field : Fields.of(object).asList()) {
            if (!MessageBuilder.canBuild(field)) continue;
            this.build(message, field, MessageBuilder.valueOf(field, object));
        }
        return message;
    }

    private void build(Message message, Field field, Object value) {
        if (Objects.isNull(value) || MessageBuilder.isEmpty(value)) {
            return;
        }
        this.builderOf(field).build(message, field, value);
    }

    private AttributeBuilder builderOf(Field field) {
        return MessageBuilder.isPrimitive(field) ? this::buildPrimitive : this::buildComposite;
    }

    private void buildPrimitive(Message message, Field field, Object value) {
        MessageBuilder.valuesIn(field, value).forEach(o -> MessageBuilder.writeAttribute(message, field, o));
    }

    private void buildComposite(Message message, Field field, Object value) {
        MessageBuilder.valuesIn(field, value).forEach(o -> message.add(MessageBuilder.toMessage(o)));
    }

    private static List valuesIn(Field field, Object value) {
        return MessageBuilder.isList(field) ? (List<Object>)value : (MessageBuilder.isArray(field) ? Arrays.asList((Object[])value) : Collections.singletonList(value));
    }

    private static boolean isList(Field field) {
        return field.getType().isAssignableFrom(List.class);
    }

    private static boolean isArray(Field field) {
        return field.getType().isArray();
    }

    private static boolean isPrimitive(Field field) {
        Class<?> aClass = field.getType();
        return MessageBuilder.isPrimitive(aClass) || MessageBuilder.isEnum(aClass) || MessageBuilder.isArrayOfPrimitives(aClass) || MessageBuilder.isListOfPrimitives(field);
    }

    private static void writeAttribute(Message message, Field field, Object value) {
        String name = field.getName();
        if (value instanceof Double) {
            message.append(name, (Double)value);
        } else if (value instanceof Boolean) {
            message.append(name, (Boolean)value);
        } else if (value instanceof Integer) {
            message.append(name, (Integer)value);
        } else {
            message.append(name, value == null ? null : value.toString());
        }
    }

    private static boolean canBuild(Field field) {
        return !Modifier.isTransient(field.getModifiers()) && !Modifier.isStatic(field.getModifiers());
    }

    private static Object valueOf(Field field, Object object) {
        try {
            field.setAccessible(true);
            return field.get(object);
        }
        catch (IllegalAccessException e) {
            return null;
        }
    }

    private static boolean isArrayOfPrimitives(Class<?> aClass) {
        return aClass.isArray() && MessageBuilder.isPrimitive(aClass.getComponentType());
    }

    private static boolean isListOfPrimitives(Field field) {
        return field.getType().isAssignableFrom(List.class) && MessageBuilder.isPrimitive(field.getGenericType().toString());
    }

    private static boolean isEnum(Class<?> aClass) {
        return aClass.isEnum();
    }

    private static boolean isPrimitive(Class<?> aClass) {
        return MessageBuilder.isPrimitive(aClass.getName()) || aClass.isPrimitive();
    }

    private static boolean isPrimitive(String className) {
        return MessageBuilder.checkPrimitives(className.contains("<") ? className.substring(className.indexOf(60) + 1) : className);
    }

    private static boolean checkPrimitives(String name) {
        return Arrays.stream(primitives).anyMatch(name::startsWith);
    }

    private static boolean isEmpty(Object value) {
        return value == null || value.getClass().isArray() && ((Object[])value).length == 0 || value instanceof List && ((List)value).isEmpty();
    }

    private static interface AttributeBuilder {
        public void build(Message var1, Field var2, Object var3);
    }
}

