/*
 * Decompiled with CFR 0.152.
 */
package io.intino.alexandria.message;

import io.intino.alexandria.message.Message;
import io.intino.alexandria.message.Parser;
import java.time.Instant;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;

public class DataValue
implements Message.Value {
    private final String data;

    public DataValue(String data) {
        this.data = data;
    }

    public DataValue(Object data) {
        this.data = data.toString();
    }

    @Override
    public String data() {
        return this.data;
    }

    @Override
    public <T> T as(Class<T> type) {
        if (this.data != null) {
            return (T)Parser.of(type).parse(this.data);
        }
        if (type.isArray()) {
            return (T)new Object[0];
        }
        return null;
    }

    @Override
    public Instant asInstant() {
        return Instant.parse(this.data);
    }

    @Override
    public int asInteger() {
        return Integer.parseInt(this.data);
    }

    @Override
    public Long asLong() {
        return Long.parseLong(this.data);
    }

    @Override
    public String asString() {
        return this.data;
    }

    @Override
    public double asDouble() {
        return Double.parseDouble(this.data);
    }

    @Override
    public boolean asBoolean() {
        return Boolean.parseBoolean(this.data);
    }

    @Override
    public List<Message.Value[]> asTable() {
        return Arrays.stream(this.data.split("\\u0001")).map(r -> (Message.Value[])Arrays.stream(r.split("\t")).map(DataValue::new).toArray(Message.Value[]::new)).collect(Collectors.toList());
    }

    public String toString() {
        return this.data;
    }
}

