/*
 * Decompiled with CFR 0.152.
 */
package io.intino.alexandria.mapp;

import io.intino.alexandria.logger.Logger;
import io.intino.alexandria.mapp.Mapp;
import io.intino.alexandria.mapp.MappStream;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;

public class MappReader
implements MappStream {
    final int size;
    final List<String> labels;
    final EntryReader entryReader;
    private final DataInputStream inputStream;
    private final String name;
    private int index;

    public MappReader(File file) throws IOException {
        this(MappReader.baseName(file.getName()), file.exists() ? new FileInputStream(file) : MappReader.emptyMappFile());
    }

    public MappReader(String name, File file) throws IOException {
        this(name, file.exists() ? new FileInputStream(file) : MappReader.emptyMappFile());
    }

    public MappReader(String name, InputStream inputStream) throws IOException {
        this.inputStream = new DataInputStream(new BufferedInputStream(inputStream));
        this.name = name;
        this.labels = this.readLabels();
        this.index = 0;
        this.size = this.inputStream.readInt();
        this.entryReader = new EntryReader();
        if (this.size == 0) {
            this.close();
        }
    }

    private static ByteArrayInputStream emptyMappFile() {
        return new ByteArrayInputStream(new byte[]{0, 0, 0, 0, 0, 0, 0, 0});
    }

    private static String baseName(String file) {
        return file.substring(0, file.lastIndexOf("."));
    }

    public String name() {
        return this.name;
    }

    public int size() {
        return this.size;
    }

    public List<String> labels() {
        return this.labels;
    }

    @Override
    public boolean hasNext() {
        return this.index < this.size;
    }

    @Override
    public MappStream.Item next() {
        Mapp.Entry entry = this.entryReader.readEntry();
        if (++this.index >= this.size) {
            this.close();
        }
        return this.mappItem(entry);
    }

    @Override
    public void close() {
        try {
            this.inputStream.close();
        }
        catch (IOException e) {
            Logger.error(e);
        }
    }

    private List<String> readLabels() throws IOException {
        ArrayList<String> values = new ArrayList<String>();
        int count = this.inputStream.readInt();
        for (int i = 0; i < count; ++i) {
            values.add(this.inputStream.readUTF());
        }
        return values;
    }

    private MappStream.Item mappItem(final Mapp.Entry entry) {
        return new MappStream.Item(){

            @Override
            public long key() {
                return entry.key;
            }

            @Override
            public String value() {
                int value = entry.value;
                return value == -1 ? null : MappReader.this.labels.get(value);
            }

            public String toString() {
                return "" + entry;
            }
        };
    }

    class EntryReader {
        private Mapp.Entry[] data = new Mapp.Entry[256];
        private long base = 0L;
        private int index = 0;
        private int count = 0;

        EntryReader() {
            this.init();
        }

        private void init() {
            try {
                this.readBlock();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }

        Mapp.Entry readEntry() {
            try {
                if (this.index == this.count) {
                    this.readBlock();
                }
                return this.data[this.index++];
            }
            catch (IOException e) {
                Logger.error(e);
                return null;
            }
        }

        private void readBlock() throws IOException {
            this.readBase();
            this.readData();
            this.index = 0;
        }

        private void readBase() throws IOException {
            int level = MappReader.this.inputStream.read();
            if (level < 0) {
                throw new EOFException();
            }
            this.base >>= level << 3;
            for (int i = 1; i <= level; ++i) {
                this.base = this.base << 8 | (long)(MappReader.this.inputStream.readByte() & 0xFF);
            }
        }

        private void readData() throws IOException {
            this.count = MappReader.this.inputStream.readByte() & 0xFF;
            if (this.count == 0) {
                this.count = 256;
            }
            for (int i = 0; i < this.count; ++i) {
                byte readByte = MappReader.this.inputStream.readByte();
                this.data[i] = new Mapp.Entry(this.base << 8 | (long)(readByte & 0xFF), this.readValue());
            }
        }

        private int readValue() throws IOException {
            byte read;
            long result = 0L;
            int shift = 0;
            do {
                read = (byte)MappReader.this.inputStream.read();
                result += ((long)read & 0x7FL) << shift;
                shift += 7;
            } while (read < 0);
            return (int)result;
        }
    }
}

