/*
 * Decompiled with CFR 0.152.
 */
package io.intino.alexandria.jms;

import io.intino.alexandria.logger.Logger;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.Session;

public abstract class JmsConsumer {
    final Session session;
    final Destination destination;
    List<Consumer<Message>> listeners;
    MessageConsumer consumer;

    JmsConsumer(Session session, Destination destination) {
        this.session = session;
        this.destination = destination;
        this.listeners = new ArrayList<Consumer<Message>>();
    }

    public void listen(Consumer<Message> listener) {
        try {
            this.listeners.add(listener);
            if (this.consumer == null) {
                this.consumer = this.session.createConsumer(this.destination, null, true);
                this.consumer.setMessageListener(m -> this.listeners.forEach(l -> l.accept(m)));
            }
        }
        catch (Exception e) {
            Logger.error(e);
        }
    }

    public List<Consumer<Message>> listeners() {
        return Collections.unmodifiableList(this.listeners);
    }

    public void removeListener(Consumer<Message> listener) {
        this.listeners.remove(listener);
    }

    public void close() {
        if (this.consumer != null) {
            try {
                this.consumer.close();
            }
            catch (JMSException e) {
                Logger.error(e);
            }
        }
    }
}

