/*
 * Decompiled with CFR 0.152.
 */
package io.intino.alexandria.ingestion;

import io.intino.alexandria.Session;
import io.intino.alexandria.ingestion.EventSession;
import io.intino.alexandria.ingestion.FS;
import io.intino.alexandria.ingestion.SetSession;
import io.intino.alexandria.logger.Logger;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class SessionHandler {
    private final File root;
    private final List<PrivateSession> sessions = new ArrayList<PrivateSession>();

    public SessionHandler() {
        this.root = null;
    }

    public SessionHandler(File root) {
        this.root = root;
        this.root.mkdirs();
        this.sessions.addAll(this.loadFileSessions());
    }

    public SetSession createSetSession() {
        PrivateProvider provider = new PrivateProvider();
        return new SetSession(provider);
    }

    public SetSession createSetSession(int autoFlushSize) {
        PrivateProvider provider = new PrivateProvider();
        return new SetSession(provider, autoFlushSize);
    }

    public EventSession createEventSession() {
        return new EventSession(new PrivateProvider());
    }

    public EventSession createEventSession(int autoFlushSize) {
        return new EventSession(new PrivateProvider(), autoFlushSize);
    }

    public void pushTo(URI uri) {
    }

    public void pushTo(File stageFolder) {
        File destination = new File(stageFolder, this.root.getName());
        destination.mkdirs();
        this.sessions().forEach(s -> this.push((Session)s, destination));
    }

    public void clear() {
        this.sessions.stream().filter(s -> s.data() instanceof FileSessionData).forEach(s -> ((FileSessionData)s.data()).file().delete());
        this.sessions.clear();
    }

    public Stream<Session> sessions() {
        return this.sessions.stream().map(s -> new Session((PrivateSession)s){
            final /* synthetic */ PrivateSession val$s;
            {
                this.val$s = privateSession;
            }

            @Override
            public String name() {
                return this.val$s.name();
            }

            @Override
            public Session.Type type() {
                return this.val$s.type();
            }

            @Override
            public InputStream inputStream() {
                return this.val$s.inputStream();
            }
        });
    }

    private List<PrivateSession> loadFileSessions() {
        return this.sessionFiles().map(f -> new PrivateSession(this.name((File)f), this.typeOf((File)f), new FileSessionData((File)f))).collect(Collectors.toList());
    }

    private Stream<File> sessionFiles() {
        return this.root == null ? Stream.empty() : FS.allFilesIn(this.root, path -> path.getName().endsWith(".session"));
    }

    private String name(File f) {
        return f.getName().substring(0, f.getName().indexOf(this.typeOf(f).name()) - 1);
    }

    private Session.Type typeOf(File f) {
        String[] split = f.getName().split("\\.");
        return Session.Type.valueOf(split[split.length - 2]);
    }

    private void push(Session session, File stageFolder) {
        FS.copyInto(this.fileFor(session, stageFolder), session.inputStream());
    }

    private File fileFor(Session session, File stageFolder) {
        return new File(stageFolder, this.filename(session));
    }

    private String filename(Session session) {
        return session.name() + "." + session.type() + ".session";
    }

    private class PrivateProvider
    implements Provider {
        private PrivateProvider() {
        }

        @Override
        public OutputStream outputStream(Session.Type type) {
            return this.outputStream("", type);
        }

        @Override
        public OutputStream outputStream(String name, Session.Type type) {
            PrivateSession session = this.session(name + this.suffix(), type);
            SessionHandler.this.sessions.add(session);
            return session.outputStream();
        }

        @Override
        public File file(String name, Session.Type type) {
            PrivateSession session = this.session(name + this.suffix(), type);
            SessionHandler.this.sessions.add(session);
            return session.file();
        }

        private PrivateSession session(String name, Session.Type type) {
            return new PrivateSession(name, type, SessionHandler.this.root == null ? new MemorySessionData() : new FileSessionData(this.fileOf(name, type)));
        }

        private File fileOf(String name, Session.Type type) {
            return new File(SessionHandler.this.root, this.filename(name, type));
        }

        private String filename(String name, Session.Type type) {
            return name + this.extensionOf(type);
        }

        private String suffix() {
            return "#" + UUID.randomUUID().toString();
        }

        private String extensionOf(Session.Type type) {
            return "." + type.name() + ".session";
        }
    }

    private static class PrivateSession {
        private final String name;
        private final Session.Type type;
        private final SessionData sessionData;

        PrivateSession(String name, Session.Type type, SessionData sessionData) {
            this.name = name;
            this.type = type;
            this.sessionData = sessionData;
        }

        public String name() {
            return this.name;
        }

        public Session.Type type() {
            return this.type;
        }

        SessionData data() {
            return this.sessionData;
        }

        InputStream inputStream() {
            return this.sessionData.inputStream();
        }

        OutputStream outputStream() {
            return this.sessionData.outputStream();
        }

        public File file() {
            return this.sessionData.outputFile();
        }
    }

    private static class MemorySessionData
    implements SessionData {
        private final ByteArrayOutputStream outputStream = new ByteArrayOutputStream();

        @Override
        public InputStream inputStream() {
            return new ByteArrayInputStream(this.outputStream.toByteArray());
        }

        @Override
        public OutputStream outputStream() {
            return this.outputStream;
        }

        @Override
        public File outputFile() {
            return null;
        }
    }

    private static class FileSessionData
    implements SessionData {
        private final File file;

        FileSessionData(File file) {
            this.file = file;
        }

        @Override
        public InputStream inputStream() {
            try {
                return new FileInputStream(this.file);
            }
            catch (FileNotFoundException e) {
                Logger.error(e);
                return null;
            }
        }

        public File file() {
            return this.file;
        }

        @Override
        public OutputStream outputStream() {
            try {
                if (!this.file.exists()) {
                    this.file.createNewFile();
                }
                return new FileOutputStream(this.file);
            }
            catch (IOException e) {
                Logger.error(e);
                return null;
            }
        }

        @Override
        public File outputFile() {
            return this.file;
        }
    }

    public static interface Provider {
        public OutputStream outputStream(Session.Type var1);

        public OutputStream outputStream(String var1, Session.Type var2);

        public File file(String var1, Session.Type var2);
    }

    private static interface SessionData {
        public InputStream inputStream();

        public OutputStream outputStream();

        public File outputFile();
    }
}

