/*
 * Decompiled with CFR 0.152.
 */
package io.intino.alexandria.http.spark;

import io.intino.alexandria.Resource;
import io.intino.alexandria.exceptions.AlexandriaError;
import io.intino.alexandria.http.spark.MimeTypes;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.nio.file.Files;
import javax.servlet.http.HttpServletResponse;
import spark.Response;
import spark.utils.IOUtils;

class SparkWriter {
    private final Response response;

    SparkWriter(Response response) {
        this.response = response;
    }

    void write(Object object) {
        this.write(object, null);
    }

    void write(Object object, String name) {
        this.write(object, name, false);
    }

    void write(Object object, String name, boolean embedded) {
        if (object instanceof File) {
            this.writeFile((File)object, embedded);
        } else if (object instanceof Resource) {
            this.writeResource((Resource)object, embedded);
        } else if (object instanceof InputStream) {
            this.writeStream((InputStream)object, name, embedded);
        } else if (object instanceof byte[]) {
            this.writeBytes((byte[])object, name, embedded);
        } else {
            this.writeResponse(object.toString(), name);
        }
    }

    void writeHeader(String name, String value) {
        this.response.header(name, value);
    }

    private void writeResponse(String message, String contentType) {
        try {
            this.writeResponse(message, contentType, this.response.raw());
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void writeError(AlexandriaError response, String message) {
        try {
            this.writeResponseError(response.code(), message, this.response.raw());
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void writeFile(File file, boolean embedded) {
        this.writeResponse(file, embedded, this.response.raw());
    }

    private void writeStream(InputStream stream, String filename, boolean embedded) {
        this.writeResponse(filename, stream, embedded, this.response.raw());
    }

    private void writeResource(Resource resource, boolean embedded) {
        this.writeResponse(resource.name(), resource.stream(), embedded, this.response.raw());
    }

    private void writeBytes(byte[] content, String filename, boolean embedded) {
        if (filename == null) {
            filename = "default.bin";
        }
        this.writeResponse(filename, content, embedded, this.response.raw());
    }

    private void writeResponse(String content, String contentType, HttpServletResponse response) throws IOException {
        response.setHeader("X-Content-Type-Options", "nosniff");
        response.setHeader("Cache-Control", "no-cache, no-store, must-revalidate");
        response.setHeader("Pragma", "no-cache");
        response.setHeader("Expires", "0");
        response.setContentType(contentType != null ? contentType : "text/html; charset=UTF-8");
        response.setCharacterEncoding("UTF-8");
        PrintWriter writer = response.getWriter();
        writer.print(content);
        writer.close();
    }

    private void writeResponse(File file, boolean embedded, HttpServletResponse response) {
        try {
            response.setContentType(MimeTypes.getFromFile(file));
            response.setHeader("Content-Disposition", (embedded ? "inline" : "attachment") + ";filename=" + file.getName());
            this.writeResponse(this.readFile(file), response);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void writeResponse(String filename, InputStream stream, boolean embedded, HttpServletResponse response) {
        try {
            byte[] content = IOUtils.toByteArray(stream);
            String contentType = filename != null ? MimeTypes.getFromFilename(filename) : MimeTypes.getFromStream(new ByteArrayInputStream(content));
            response.setContentType(contentType);
            response.setHeader("Content-Disposition", (embedded ? "inline" : "attachment") + ";filename=" + (filename != null ? filename : "resource." + MimeTypes.getExtension(contentType)));
            this.writeResponse(content, response);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void writeResponse(String filename, byte[] content, boolean embedded, HttpServletResponse response) {
        response.setContentType(MimeTypes.getFromFilename(filename));
        response.setHeader("Content-Disposition", (embedded ? "inline" : "attachment") + "attachment; filename=" + filename);
        this.writeResponse(content, response);
    }

    private void writeResponse(byte[] content, HttpServletResponse response) {
        try {
            response.setContentLength(content.length);
            response.getOutputStream().write(content);
            response.getOutputStream().flush();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void writeResponseError(String code, String error, HttpServletResponse response) throws IOException {
        response.setStatus(Integer.parseInt(code));
        response.setCharacterEncoding("UTF-8");
        response.setContentType("text/html");
        response.getWriter().print(error);
        response.flushBuffer();
    }

    private byte[] readFile(File file) throws IOException {
        return Files.readAllBytes(file.toPath());
    }
}

