/*
 * Decompiled with CFR 0.152.
 */
package io.intino.alexandria.http.pushservice;

import io.intino.alexandria.http.pushservice.Client;
import io.intino.alexandria.http.pushservice.PushService;
import io.intino.alexandria.http.pushservice.Session;

public class MessageCarrier {
    private final Session session;
    private final Client client;
    private final PushService service;

    public MessageCarrier(PushService service, Session session, Client client) {
        this.session = session;
        this.client = client;
        this.service = service;
    }

    public void notifyAll(String message) {
        this.service.pushBroadcast(message);
    }

    public void notifySession(String message) {
        this.service.pushToSession(this.session, message);
    }

    public void notifyClient(String message) {
        this.service.pushToClient(this.client, message);
    }
}

