/*
 * Decompiled with CFR 0.152.
 */
package io.intino.alexandria.event;

import io.intino.alexandria.event.Event;
import java.time.Instant;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.stream.IntStream;
import java.util.stream.Stream;

public interface EventStream {
    public Event current();

    public Event next();

    public boolean hasNext();

    default public void forEachRemaining(Consumer<Event> action) {
        Objects.requireNonNull(action);
        while (this.hasNext()) {
            action.accept(this.next());
        }
    }

    public static class Empty
    implements EventStream {
        @Override
        public Event current() {
            return null;
        }

        @Override
        public Event next() {
            return null;
        }

        @Override
        public boolean hasNext() {
            return false;
        }
    }

    public static class Sequence
    implements EventStream {
        private final Iterator<EventStream> iterator;
        private Event currentEvent;
        private EventStream current;

        public Sequence(EventStream ... inputs) {
            this.iterator = this.streamOf(inputs).iterator();
            this.current = this.iterator.next();
        }

        public static Sequence of(EventStream ... inputs) {
            return new Sequence(inputs);
        }

        private Stream<EventStream> streamOf(EventStream[] inputs) {
            return Arrays.stream(this.isEmpty(inputs) ? inputs : this.emptyInput());
        }

        private boolean isEmpty(EventStream[] inputs) {
            return inputs.length > 0;
        }

        private EventStream[] emptyInput() {
            return new EventStream[]{new Empty()};
        }

        @Override
        public Event current() {
            return this.currentEvent;
        }

        @Override
        public Event next() {
            this.currentEvent = this.current.next();
            return this.currentEvent;
        }

        @Override
        public boolean hasNext() {
            return this.current.hasNext() || this.restHasNext();
        }

        private boolean restHasNext() {
            while (this.iterator.hasNext()) {
                this.current = this.iterator.next();
                if (!this.current.hasNext()) continue;
                return true;
            }
            return false;
        }
    }

    public static class Merge
    implements EventStream {
        private Event currentEvent;
        private final EventStream[] inputs;
        private final Event[] current;

        public Merge(EventStream ... inputs) {
            this.inputs = inputs;
            this.current = (Event[])Arrays.stream(inputs).map(this::next).toArray(Event[]::new);
        }

        public static Merge of(EventStream ... inputs) {
            return new Merge(inputs);
        }

        @Override
        public Event current() {
            return this.currentEvent;
        }

        @Override
        public Event next() {
            this.currentEvent = this.next(this.minIndex());
            return this.currentEvent;
        }

        private Event next(int index) {
            Event message = this.current[index];
            this.current[index] = this.next(this.inputs[index]);
            return message;
        }

        @Override
        public boolean hasNext() {
            return !Arrays.stream(this.current).allMatch(Objects::isNull);
        }

        private Event next(EventStream input) {
            return input.hasNext() ? input.next() : null;
        }

        private int minIndex() {
            return IntStream.range(0, this.current.length).boxed().min(this::comparingTimestamp).orElse(-1);
        }

        private int comparingTimestamp(int a, int b) {
            return this.tsOf(this.current[a]).compareTo(this.tsOf(this.current[b]));
        }

        private Instant tsOf(Event event) {
            return event != null ? event.ts() : Instant.MAX;
        }
    }
}

